/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.jenkins;

import com.netflix.spinnaker.clouddriver.artifacts.jenkins.JenkinsArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.jenkins.JenkinsArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.jenkins.JenkinsProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"jenkins.enabled"})
@EnableConfigurationProperties(value={JenkinsProperties.class})
public class JenkinsArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JenkinsArtifactConfiguration.class);
    private final JenkinsProperties jenkinsProperties;

    @Bean
    List<? extends JenkinsArtifactCredentials> jenkinsArtifactCredentials(OkHttpClient okHttpClient) {
        return this.jenkinsProperties.getMasters().stream().map(m -> {
            try {
                return new JenkinsArtifactCredentials(new JenkinsArtifactAccount(m.getName(), m.getUsername(), m.getPassword(), m.getAddress()), okHttpClient);
            }
            catch (Exception e) {
                log.warn("Failure instantiating jenkins artifact account {}: ", m, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public JenkinsArtifactConfiguration(JenkinsProperties jenkinsProperties) {
        this.jenkinsProperties = jenkinsProperties;
    }
}

