/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.jenkins;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.config.SimpleHttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.jenkins.JenkinsArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsArtifactCredentials
extends SimpleHttpArtifactCredentials<JenkinsArtifactAccount>
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(JenkinsArtifactCredentials.class);
    public static final String TYPE = "jenkins/file";
    private final String name;
    private final List<String> types = Collections.singletonList("jenkins/file");
    private final JenkinsArtifactAccount jenkinsArtifactAccount;

    JenkinsArtifactCredentials(JenkinsArtifactAccount account, OkHttpClient okHttpClient) {
        super(okHttpClient, account);
        this.jenkinsArtifactAccount = account;
        this.name = account.getName();
    }

    @Override
    protected HttpUrl getDownloadUrl(Artifact artifact) {
        String formattedJenkinsAddress = this.jenkinsArtifactAccount.getAddress().endsWith("/") ? this.jenkinsArtifactAccount.getAddress() : this.jenkinsArtifactAccount.getAddress() + "/";
        String formattedReference = artifact.getReference().startsWith("/") ? artifact.getReference() : "/" + artifact.getReference();
        String buildUrl = formattedJenkinsAddress + "job/" + artifact.getName() + "/" + artifact.getVersion() + "/artifact" + formattedReference;
        HttpUrl url = HttpUrl.parse((String)buildUrl);
        if (url == null) {
            throw new IllegalArgumentException("Malformed content URL in reference: " + buildUrl + ". Read more here https://www.spinnaker.io/reference/artifacts/types/");
        }
        return url;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }
}

