/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.kubernetes;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.kubernetes.KubernetesArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.kubernetes.KubernetesArtifactType;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(KubernetesArtifactCredentials.class);
    private final String name;
    private final List<String> types;

    public KubernetesArtifactCredentials(KubernetesArtifactAccount account) {
        this.name = account.getName();
        this.types = Arrays.stream(KubernetesArtifactType.values()).map(KubernetesArtifactType::getType).collect(Collectors.toList());
        this.types.remove("docker/image");
    }

    @Override
    public InputStream download(Artifact artifact) {
        throw new UnsupportedOperationException("Kubernetes artifacts are retrieved by kubernetes directly");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesArtifactCredentials)) {
            return false;
        }
        KubernetesArtifactCredentials other = (KubernetesArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }

    public String toString() {
        return "KubernetesArtifactCredentials(name=" + this.getName() + ", types=" + this.getTypes() + ")";
    }
}

