/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.oracle;

import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactProviderProperties;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.oracle.enabled"})
@EnableConfigurationProperties(value={OracleArtifactProviderProperties.class})
public class OracleArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OracleArtifactConfiguration.class);
    private final OracleArtifactProviderProperties oracleArtifactProviderProperties;

    @Bean
    List<? extends OracleArtifactCredentials> oracleArtifactCredentials(String clouddriverUserAgentApplicationName) {
        return this.oracleArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                return new OracleArtifactCredentials(clouddriverUserAgentApplicationName, (OracleArtifactAccount)a);
            }
            catch (Exception e) {
                log.warn("Failure instantiating oracle artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public OracleArtifactConfiguration(OracleArtifactProviderProperties oracleArtifactProviderProperties) {
        this.oracleArtifactProviderProperties = oracleArtifactProviderProperties;
    }
}

