/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.s3;

import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactProviderProperties;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.s3.enabled"})
@EnableConfigurationProperties(value={S3ArtifactProviderProperties.class})
public class S3ArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(S3ArtifactConfiguration.class);
    private final S3ArtifactProviderProperties s3ArtifactProviderProperties;

    @Bean
    List<? extends S3ArtifactCredentials> s3ArtifactCredentials() {
        return this.s3ArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                return new S3ArtifactCredentials((S3ArtifactAccount)a);
            }
            catch (IllegalArgumentException e) {
                log.warn("Failure instantiating s3 artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public S3ArtifactConfiguration(S3ArtifactProviderProperties s3ArtifactProviderProperties) {
        this.s3ArtifactProviderProperties = s3ArtifactProviderProperties;
    }
}

