/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.Yaml;

@Component
public class ArtifactDownloader {
    private final ArtifactCredentialsRepository artifactCredentialsRepository;
    private final ObjectMapper objectMapper;
    final Yaml yamlParser;

    @Autowired
    public ArtifactDownloader(ArtifactCredentialsRepository artifactCredentialsRepository, ObjectMapper objectMapper) {
        this.artifactCredentialsRepository = artifactCredentialsRepository;
        this.objectMapper = objectMapper;
        this.yamlParser = new Yaml();
    }

    public InputStream download(Artifact artifact) throws IOException {
        String artifactAccount = artifact.getArtifactAccount();
        if (StringUtils.isEmpty((CharSequence)artifactAccount)) {
            throw new IllegalArgumentException("An artifact account must be supplied to download this artifact: " + artifactAccount);
        }
        ArtifactCredentials credentials = this.artifactCredentialsRepository.getAllCredentials().stream().filter(c -> c.getName().equals(artifactAccount)).findFirst().orElseThrow(() -> new IllegalArgumentException("No credentials with name '" + artifactAccount + "' could be found."));
        if (!credentials.handlesType(artifact.getType())) {
            throw new IllegalArgumentException("Artifact credentials '" + artifactAccount + "' cannot handle artifacts of type '" + artifact.getType() + "'");
        }
        return credentials.download(artifact);
    }

    public <T> T downloadAsYaml(Artifact artifact, Class<T> clazz) throws IOException {
        InputStream is = this.download(artifact);
        Object parsed = this.yamlParser.load(is);
        return (T)this.objectMapper.convertValue(parsed, clazz);
    }
}

