/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.bitbucket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.bitbucket.BitbucketArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.bitbucket.BitbucketArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.bitbucket.BitbucketArtifactProviderProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(value={"artifacts.bitbucket.enabled"})
@EnableScheduling
public class BitbucketArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BitbucketArtifactConfiguration.class);
    @Autowired
    BitbucketArtifactProviderProperties bitbucketArtifactProviderProperties;
    @Autowired
    ArtifactCredentialsRepository artifactCredentialsRepository;
    @Autowired
    OkHttpClient bitbucketOkHttpClient;
    @Autowired
    ObjectMapper objectMapper;

    @Scope(value="prototype")
    @Bean
    @ConfigurationProperties(value="artifacts.bitbucket")
    BitbucketArtifactProviderProperties bitbucketArtifactProviderProperties() {
        return new BitbucketArtifactProviderProperties();
    }

    @Bean
    OkHttpClient bitbucketOkHttpClient() {
        return new OkHttpClient();
    }

    @Bean
    List<? extends BitbucketArtifactCredentials> bitbucketArtifactCredentials() {
        return this.bitbucketArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                BitbucketArtifactCredentials c = new BitbucketArtifactCredentials((BitbucketArtifactAccount)a, this.bitbucketOkHttpClient, this.objectMapper);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (Exception e) {
                log.warn("Failure instantiating Bitbucket artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

