/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitlab;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitlabArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(GitlabArtifactCredentials.class);
    private final String name;
    @JsonIgnore
    private final Request.Builder requestBuilder;
    @JsonIgnore
    OkHttpClient okHttpClient;
    @JsonIgnore
    ObjectMapper objectMapper;

    public GitlabArtifactCredentials(GitlabArtifactAccount account, OkHttpClient okHttpClient, ObjectMapper objectMapper) {
        boolean useAuth;
        this.name = account.getName();
        this.okHttpClient = okHttpClient;
        this.objectMapper = objectMapper;
        Request.Builder builder = new Request.Builder();
        boolean useToken = !StringUtils.isEmpty((CharSequence)account.getToken());
        boolean useTokenFile = !StringUtils.isEmpty((CharSequence)account.getTokenFile());
        boolean bl = useAuth = useToken || useTokenFile;
        if (useAuth) {
            String authHeader = "";
            if (useTokenFile) {
                authHeader = this.credentialsFromFile(account.getTokenFile());
            } else if (useToken) {
                authHeader = account.getToken();
            }
            builder.header("Private-Token", authHeader);
            log.info("Loaded credentials for Gitlab Artifact Account {}", (Object)account.getName());
        } else {
            log.info("No credentials included with Gitlab Artifact Account {}", (Object)account.getName());
        }
        this.requestBuilder = builder;
    }

    private String credentialsFromFile(String filename) {
        try {
            String credentials = FileUtils.readFileToString((File)new File(filename));
            return credentials.replace("\n", "");
        }
        catch (IOException e) {
            log.error("Could not read Gitlab credentials file {}", (Object)filename, (Object)e);
            return null;
        }
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        HttpUrl.Builder fileUrl;
        try {
            fileUrl = HttpUrl.parse((String)artifact.getReference()).newBuilder();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed gitlab content URL in 'reference'. Read more here https://www.spinnaker.io/reference/artifacts/types/gitlab-file/: " + e.getMessage(), e);
        }
        String version = artifact.getVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            log.info("No version specified for artifact {}, using 'master'.", (Object)version);
            version = "master";
        }
        fileUrl.addQueryParameter("ref", version);
        Request fileRequest = this.requestBuilder.url(fileUrl.build().toString()).build();
        try {
            Response downloadResponse = this.okHttpClient.newCall(fileRequest).execute();
            return downloadResponse.body().byteStream();
        }
        catch (IOException e) {
            throw new FailedDownloadException("Unable to download the contents of artifact " + artifact + ": " + e.getMessage(), e);
        }
    }

    @Override
    public boolean handlesType(String type) {
        return type.equals("gitlab/file");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Request.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public GitlabArtifactCredentials setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }

    public GitlabArtifactCredentials setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitlabArtifactCredentials)) {
            return false;
        }
        GitlabArtifactCredentials other = (GitlabArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Request.Builder this$requestBuilder = this.getRequestBuilder();
        Request.Builder other$requestBuilder = other.getRequestBuilder();
        if (this$requestBuilder == null ? other$requestBuilder != null : !this$requestBuilder.equals(other$requestBuilder)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitlabArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Request.Builder $requestBuilder = this.getRequestBuilder();
        result = result * 59 + ($requestBuilder == null ? 43 : $requestBuilder.hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    public String toString() {
        return "GitlabArtifactCredentials(name=" + this.getName() + ", requestBuilder=" + this.getRequestBuilder() + ", okHttpClient=" + this.getOkHttpClient() + ", objectMapper=" + this.getObjectMapper() + ")";
    }

    public class FailedDownloadException
    extends IOException {
        public FailedDownloadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

