/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.s3;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class S3ArtifactCredentials
implements ArtifactCredentials {
    private final String name;
    private final String apiEndpoint;
    private final String apiRegion;
    private final String region;

    public S3ArtifactCredentials(S3ArtifactAccount account) throws IllegalArgumentException {
        this.name = account.getName();
        this.apiEndpoint = account.getApiEndpoint();
        this.apiRegion = account.getApiRegion();
        this.region = account.getRegion();
    }

    protected AmazonS3 getS3Client() {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (!StringUtils.isEmpty((CharSequence)this.apiEndpoint)) {
            AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(this.apiEndpoint, this.apiRegion);
            builder.setEndpointConfiguration(endpoint);
            builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        } else if (!StringUtils.isEmpty((CharSequence)this.region)) {
            builder.setRegion(this.region);
        }
        return (AmazonS3)builder.build();
    }

    @Override
    public InputStream download(Artifact artifact) throws IllegalArgumentException {
        int slash;
        String reference = artifact.getReference();
        if (reference.startsWith("s3://")) {
            reference = reference.substring("s3://".length());
        }
        if ((slash = reference.indexOf("/")) <= 0) {
            throw new IllegalArgumentException("S3 references must be of the format s3://<bucket>/<file-path>, got: " + artifact);
        }
        String bucketName = reference.substring(0, slash);
        String path = reference.substring(slash + 1);
        S3Object s3obj = this.getS3Client().getObject(bucketName, path);
        return s3obj.getObjectContent();
    }

    @Override
    public boolean handlesType(String type) {
        return type.equals("s3/object");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public String getApiRegion() {
        return this.apiRegion;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3ArtifactCredentials)) {
            return false;
        }
        S3ArtifactCredentials other = (S3ArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$apiEndpoint = this.getApiEndpoint();
        String other$apiEndpoint = other.getApiEndpoint();
        if (this$apiEndpoint == null ? other$apiEndpoint != null : !this$apiEndpoint.equals(other$apiEndpoint)) {
            return false;
        }
        String this$apiRegion = this.getApiRegion();
        String other$apiRegion = other.getApiRegion();
        if (this$apiRegion == null ? other$apiRegion != null : !this$apiRegion.equals(other$apiRegion)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !this$region.equals(other$region));
    }

    protected boolean canEqual(Object other) {
        return other instanceof S3ArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $apiEndpoint = this.getApiEndpoint();
        result = result * 59 + ($apiEndpoint == null ? 43 : $apiEndpoint.hashCode());
        String $apiRegion = this.getApiRegion();
        result = result * 59 + ($apiRegion == null ? 43 : $apiRegion.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        return result;
    }

    public String toString() {
        return "S3ArtifactCredentials(name=" + this.getName() + ", apiEndpoint=" + this.getApiEndpoint() + ", apiRegion=" + this.getApiRegion() + ", region=" + this.getRegion() + ")";
    }
}

