/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.embedded;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.embedded.EmbeddedArtifactAccount;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedArtifactCredentials.class);
    private final String name;
    private final List<String> types = Arrays.asList("embedded/base64");
    @JsonIgnore
    private final Base64.Decoder base64Decoder;

    public EmbeddedArtifactCredentials(EmbeddedArtifactAccount account) {
        this.name = account.getName();
        this.base64Decoder = Base64.getDecoder();
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        String type = artifact.getType();
        if (type.equals("embedded/base64")) {
            return this.fromBase64(artifact);
        }
        throw new NotImplementedException("Embedded type '" + type + "' is not handled.");
    }

    private InputStream fromBase64(Artifact artifact) {
        String reference = artifact.getReference();
        return new ByteArrayInputStream(this.base64Decoder.decode(reference));
    }

    @Override
    public boolean handlesType(String type) {
        return type.startsWith("embedded/");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public Base64.Decoder getBase64Decoder() {
        return this.base64Decoder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddedArtifactCredentials)) {
            return false;
        }
        EmbeddedArtifactCredentials other = (EmbeddedArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        Base64.Decoder this$base64Decoder = this.getBase64Decoder();
        Base64.Decoder other$base64Decoder = other.getBase64Decoder();
        return !(this$base64Decoder == null ? other$base64Decoder != null : !this$base64Decoder.equals(other$base64Decoder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddedArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        Base64.Decoder $base64Decoder = this.getBase64Decoder();
        result = result * 59 + ($base64Decoder == null ? 43 : $base64Decoder.hashCode());
        return result;
    }

    public String toString() {
        return "EmbeddedArtifactCredentials(name=" + this.getName() + ", types=" + this.getTypes() + ", base64Decoder=" + this.getBase64Decoder() + ")";
    }
}

