/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.github;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.github.GitHubArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.github.GitHubArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.github.GitHubArtifactProviderProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(value={"artifacts.github.enabled"})
@EnableScheduling
public class GitHubArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GitHubArtifactConfiguration.class);
    @Autowired
    GitHubArtifactProviderProperties gitHubArtifactProviderProperties;
    @Autowired
    ArtifactCredentialsRepository artifactCredentialsRepository;
    @Autowired
    ObjectMapper objectMapper;

    @Scope(value="prototype")
    @Bean
    @ConfigurationProperties(value="artifacts.github")
    GitHubArtifactProviderProperties githubArtifactProviderProperties() {
        return new GitHubArtifactProviderProperties();
    }

    @Bean
    OkHttpClient gitHubOkHttpClient() {
        return new OkHttpClient();
    }

    @Bean
    List<? extends GitHubArtifactCredentials> gitHubArtifactCredentials(OkHttpClient gitHubOkHttpClient) {
        return this.gitHubArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                GitHubArtifactCredentials c = new GitHubArtifactCredentials((GitHubArtifactAccount)a, gitHubOkHttpClient, this.objectMapper);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (Exception e) {
                log.warn("Failure instantiating GitHub artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

