/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.oracle;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactProviderProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(value={"artifacts.oracle.enabled"})
@EnableScheduling
public class OracleArtifactConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OracleArtifactConfiguration.class);
    @Autowired
    OracleArtifactProviderProperties oracleArtifactProviderProperties;
    @Autowired
    ArtifactCredentialsRepository artifactCredentialsRepository;

    @Scope(value="prototype")
    @Bean
    @ConfigurationProperties(value="artifacts.oracle")
    OracleArtifactProviderProperties oracleArtifactProviderProperties() {
        return new OracleArtifactProviderProperties();
    }

    @Bean
    List<? extends OracleArtifactCredentials> oracleArtifactCredentials(String clouddriverUserAgentApplicationName) {
        return this.oracleArtifactProviderProperties.getAccounts().stream().map(a -> {
            try {
                OracleArtifactCredentials c = new OracleArtifactCredentials(clouddriverUserAgentApplicationName, (OracleArtifactAccount)a);
                this.artifactCredentialsRepository.save(c);
                return c;
            }
            catch (IOException | GeneralSecurityException e) {
                log.warn("Failure instantiating oracle artifact account {}: ", a, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

