/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.oracle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactClient;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleArtifactCredentials
implements ArtifactCredentials {
    private static final Logger log = LoggerFactory.getLogger(OracleArtifactCredentials.class);
    private static String ARTIFACT_REFERENCE_PREFIX = "oci://";
    private static final String ARTIFACT_URI = "https://objectstorage.{arg0}.oraclecloud.com/n/{arg1}/b/{arg2}/o/{arg3}";
    private final List<String> types = Arrays.asList("oracle/object");
    private final String name;
    private final String namespace;
    private final String region;
    private final String userId;
    private final String fingerprint;
    private final String sshPrivateKeyFilePath;
    private final String privateKeyPassphrase;
    private final String tenancyId;
    @JsonIgnore
    private final OracleArtifactClient client;

    public OracleArtifactCredentials(String applicationName, OracleArtifactAccount account) throws IOException, GeneralSecurityException {
        this.name = account.getName();
        this.namespace = account.getNamespace();
        this.region = account.getRegion();
        this.userId = account.getUserId();
        this.fingerprint = account.getFingerprint();
        this.sshPrivateKeyFilePath = account.getSshPrivateKeyFilePath();
        this.privateKeyPassphrase = account.getPrivateKeyPassphrase();
        this.tenancyId = account.getTenancyId();
        this.client = new OracleArtifactClient(this.userId, this.sshPrivateKeyFilePath, this.privateKeyPassphrase, this.fingerprint, this.tenancyId);
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        int slash;
        String reference = artifact.getReference();
        if (reference.startsWith(ARTIFACT_REFERENCE_PREFIX)) {
            reference = reference.substring(ARTIFACT_REFERENCE_PREFIX.length());
        }
        if ((slash = reference.indexOf("/")) <= 0) {
            throw new IllegalArgumentException("Oracle references must be of the format oci://<bucket>/<file-path>, got: " + artifact);
        }
        String bucketName = reference.substring(0, slash);
        String path = reference.substring(slash + 1);
        URI uri = UriBuilder.fromPath((String)ARTIFACT_URI).build(new Object[]{this.region, this.namespace, bucketName, path});
        try {
            return this.client.readObject(uri);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == 404) {
                throw new IOException("Object not found (key: " + path + ")");
            }
            throw e;
        }
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRegion() {
        return this.region;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getSshPrivateKeyFilePath() {
        return this.sshPrivateKeyFilePath;
    }

    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public OracleArtifactClient getClient() {
        return this.client;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OracleArtifactCredentials)) {
            return false;
        }
        OracleArtifactCredentials other = (OracleArtifactCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
            return false;
        }
        String this$sshPrivateKeyFilePath = this.getSshPrivateKeyFilePath();
        String other$sshPrivateKeyFilePath = other.getSshPrivateKeyFilePath();
        if (this$sshPrivateKeyFilePath == null ? other$sshPrivateKeyFilePath != null : !this$sshPrivateKeyFilePath.equals(other$sshPrivateKeyFilePath)) {
            return false;
        }
        String this$privateKeyPassphrase = this.getPrivateKeyPassphrase();
        String other$privateKeyPassphrase = other.getPrivateKeyPassphrase();
        if (this$privateKeyPassphrase == null ? other$privateKeyPassphrase != null : !this$privateKeyPassphrase.equals(other$privateKeyPassphrase)) {
            return false;
        }
        String this$tenancyId = this.getTenancyId();
        String other$tenancyId = other.getTenancyId();
        if (this$tenancyId == null ? other$tenancyId != null : !this$tenancyId.equals(other$tenancyId)) {
            return false;
        }
        OracleArtifactClient this$client = this.getClient();
        OracleArtifactClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OracleArtifactCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        String $sshPrivateKeyFilePath = this.getSshPrivateKeyFilePath();
        result = result * 59 + ($sshPrivateKeyFilePath == null ? 43 : $sshPrivateKeyFilePath.hashCode());
        String $privateKeyPassphrase = this.getPrivateKeyPassphrase();
        result = result * 59 + ($privateKeyPassphrase == null ? 43 : $privateKeyPassphrase.hashCode());
        String $tenancyId = this.getTenancyId();
        result = result * 59 + ($tenancyId == null ? 43 : $tenancyId.hashCode());
        OracleArtifactClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public String toString() {
        return "OracleArtifactCredentials(types=" + this.getTypes() + ", name=" + this.getName() + ", namespace=" + this.getNamespace() + ", region=" + this.getRegion() + ", userId=" + this.getUserId() + ", fingerprint=" + this.getFingerprint() + ", sshPrivateKeyFilePath=" + this.getSshPrivateKeyFilePath() + ", privateKeyPassphrase=" + this.getPrivateKeyPassphrase() + ", tenancyId=" + this.getTenancyId() + ", client=" + this.getClient() + ")";
    }
}

