/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.config;

import com.netflix.spinnaker.clouddriver.artifacts.CredentialReader;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;

@NonnullByDefault
public interface TokenAuth {
    public Optional<String> getToken();

    public Optional<String> getTokenFile();

    default public Optional<String> getTokenAuthHeader() {
        return this.getTokenAsString().map(t -> "token " + t);
    }

    default public Optional<String> getTokenAsString() {
        Optional<String> result = this.getTokenFile().map(CredentialReader::credentialsFromFile);
        if (result.isPresent()) {
            return result;
        }
        return this.getToken();
    }
}

