/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gcs;

import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactProviderProperties;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.gcs.enabled"})
@EnableConfigurationProperties(value={GcsArtifactProviderProperties.class})
class GcsArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GcsArtifactConfiguration.class);
    private final GcsArtifactProviderProperties gcsArtifactProviderProperties;

    @Bean
    public CredentialsTypeProperties<GcsArtifactCredentials, GcsArtifactAccount> gcsCredentialsProperties(String clouddriverUserAgentApplicationName) {
        return CredentialsTypeProperties.builder().type("artifacts-gcs").credentialsClass(GcsArtifactCredentials.class).credentialsDefinitionClass(GcsArtifactAccount.class).defaultCredentialsSource(this.gcsArtifactProviderProperties::getAccounts).credentialsParser(a -> {
            try {
                return new GcsArtifactCredentials(clouddriverUserAgentApplicationName, (GcsArtifactAccount)a);
            }
            catch (IOException | GeneralSecurityException e) {
                log.warn("Failure instantiating gcs artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Generated
    public GcsArtifactConfiguration(GcsArtifactProviderProperties gcsArtifactProviderProperties) {
        this.gcsArtifactProviderProperties = gcsArtifactProviderProperties;
    }
}

