/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitRepo;

import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitRepoArtifactAccount;
import com.netflix.spinnaker.clouddriver.jobs.JobExecutor;
import com.netflix.spinnaker.clouddriver.jobs.JobRequest;
import com.netflix.spinnaker.clouddriver.jobs.JobResult;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GitJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitJobExecutor.class);
    private static final String SSH_KEY_PWD_ENV_VAR = "SSH_KEY_PWD";
    private static Path genericAskPassBinary;
    private final GitRepoArtifactAccount account;
    private final JobExecutor jobExecutor;
    private final String gitExecutable;
    private final AuthType authType;
    private final Path askPassBinary;

    public GitJobExecutor(GitRepoArtifactAccount account, JobExecutor jobExecutor, String gitExecutable) throws IOException {
        this.account = account;
        this.jobExecutor = jobExecutor;
        this.gitExecutable = gitExecutable;
        this.authType = !StringUtils.isEmpty((Object)account.getUsername()) && !StringUtils.isEmpty((Object)account.getPassword()) ? AuthType.USER_PASS : (!StringUtils.isEmpty((Object)account.getToken()) ? AuthType.TOKEN : (!StringUtils.isEmpty((Object)account.getSshPrivateKeyFilePath()) ? AuthType.SSH : AuthType.NONE));
        this.askPassBinary = this.initAskPass();
    }

    public void clone(String repoUrl, String branch, Path destination) throws IOException {
        if (!this.isValidReference(repoUrl)) {
            throw new IllegalArgumentException("Git reference \"" + repoUrl + "\" is invalid for credentials with auth type " + this.authType);
        }
        FileUtils.deleteDirectory((File)destination.toFile());
        FileUtils.forceMkdir((File)destination.toFile());
        log.info("Cloning git/repo {} into {}", (Object)repoUrl, (Object)destination.toString());
        String cloneCommand = this.gitExecutable + " clone --branch " + branch + " --depth 1 " + this.repoUrlWithAuth(repoUrl);
        List<String> command = this.cmdToList(cloneCommand);
        log.debug("Executing command: \"{}\"", (Object)String.join((CharSequence)" ", command));
        JobResult result = this.jobExecutor.runJob(new JobRequest(command, this.addEnvVars(System.getenv()), destination.toFile()));
        if (result.getResult() != JobResult.Result.SUCCESS) {
            throw new IOException("Failed to clone repository " + repoUrl + " into " + destination + ". Error: " + result.getError() + " Output: " + (String)result.getOutput());
        }
    }

    public void archive(Path localClone, String branch, String subDir, Path outputFile) throws IOException {
        List<String> command = Arrays.asList(this.gitExecutable, "archive", "--format", "tgz", "--output", outputFile.toString(), branch);
        if (!StringUtils.isEmpty((Object)subDir)) {
            command.add(subDir);
        }
        log.debug("Executing command: \"{}\"", (Object)String.join((CharSequence)" ", command));
        JobResult result = this.jobExecutor.runJob(new JobRequest(command, localClone.toFile()));
        if (result.getResult() != JobResult.Result.SUCCESS) {
            throw new IOException("Failed to archive repository from " + localClone + ". Error: " + result.getError() + " Output: " + (String)result.getOutput());
        }
    }

    private Path initAskPass() throws IOException {
        if (this.authType != AuthType.SSH) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)this.account.getSshPrivateKeyPassphraseCmd())) {
            File pwdCmd = new File(this.account.getSshPrivateKeyPassphraseCmd());
            if (!pwdCmd.exists() || !pwdCmd.isFile()) {
                throw new IOException("SshPrivateKeyPassphraseCmd doesn't exist or is not a file: " + this.account.getSshPrivateKeyPassphraseCmd());
            }
            return Paths.get(this.account.getSshPrivateKeyPassphraseCmd(), new String[0]);
        }
        if (genericAskPassBinary == null) {
            File askpass = File.createTempFile("askpass", null);
            if (!askpass.setExecutable(true)) {
                throw new IOException("Unable to make executable askpass script at " + askpass.toPath().toString());
            }
            FileUtils.writeStringToFile((File)askpass, (String)"#!/bin/sh\necho \"$SSH_KEY_PWD\"", (Charset)Charset.defaultCharset());
            genericAskPassBinary = askpass.toPath();
        }
        return genericAskPassBinary;
    }

    private boolean isValidReference(String reference) {
        if (this.authType == AuthType.USER_PASS || this.authType == AuthType.TOKEN) {
            return reference.startsWith("http");
        }
        if (this.authType == AuthType.SSH) {
            return reference.startsWith("ssh://") || reference.startsWith("git@");
        }
        return true;
    }

    private List<String> cmdToList(String cmd) {
        ArrayList<String> cmdList = new ArrayList<String>();
        switch (this.authType) {
            case USER_PASS: 
            case TOKEN: {
                cmdList.add("sh");
                cmdList.add("-c");
                cmdList.add(cmd);
                break;
            }
            default: {
                cmdList.addAll(Arrays.asList(cmd.split(" ")));
            }
        }
        return cmdList;
    }

    private String repoUrlWithAuth(String repoUrl) {
        if (this.authType != AuthType.USER_PASS && this.authType != AuthType.TOKEN) {
            return repoUrl;
        }
        String authPart = this.authType == AuthType.USER_PASS ? "$GIT_USER:$GIT_PASS" : "token:$GIT_TOKEN";
        try {
            URI uri = new URI(repoUrl);
            return String.format("%s://%s@%s%s%s", uri.getScheme(), authPart, uri.getHost(), uri.getPort() > 0 ? ":" + uri.getPort() : "", uri.getRawPath());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed git repo url " + repoUrl, e);
        }
    }

    private Map<String, String> addEnvVars(Map<String, String> env) {
        HashMap<String, String> result = new HashMap<String, String>(env);
        switch (this.authType) {
            case USER_PASS: {
                result.put("GIT_USER", GitJobExecutor.encodeURIComponent(this.account.getUsername()));
                result.put("GIT_PASS", GitJobExecutor.encodeURIComponent(this.account.getPassword()));
                break;
            }
            case TOKEN: {
                result.put("GIT_TOKEN", GitJobExecutor.encodeURIComponent(this.account.getToken()));
                break;
            }
            case SSH: {
                result.put("GIT_SSH_COMMAND", this.buildSshCommand());
                result.put("SSH_ASKPASS", this.askPassBinary.toString());
                result.put("DISPLAY", ":0");
                if (StringUtils.isEmpty((Object)this.account.getSshPrivateKeyPassphrase())) break;
                result.put(SSH_KEY_PWD_ENV_VAR, this.account.getSshPrivateKeyPassphrase());
            }
        }
        if (log.isDebugEnabled()) {
            result.put("GIT_CURL_VERBOSE", "1");
            result.put("GIT_TRACE", "1");
        }
        return result;
    }

    @NotNull
    private String buildSshCommand() {
        Object gitSshCmd = "setsid ssh";
        if (this.account.isSshTrustUnknownHosts()) {
            gitSshCmd = (String)gitSshCmd + " -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no";
        } else if (!StringUtils.isEmpty((Object)this.account.getSshKnownHostsFilePath())) {
            gitSshCmd = (String)gitSshCmd + " -o UserKnownHostsFile=" + this.account.getSshKnownHostsFilePath();
        }
        if (!StringUtils.isEmpty((Object)this.account.getSshPrivateKeyFilePath())) {
            gitSshCmd = (String)gitSshCmd + " -i " + this.account.getSshPrivateKeyFilePath();
        }
        return gitSshCmd;
    }

    private static String encodeURIComponent(String s) {
        if (StringUtils.isEmpty((Object)s)) {
            return s;
        }
        String result = URLEncoder.encode(s, StandardCharsets.UTF_8).replaceAll("\\+", "%20").replaceAll("\\*", "%2A").replaceAll("%21", "!").replaceAll("%27", "'").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%7E", "~");
        return result;
    }

    @Generated
    public GitRepoArtifactAccount getAccount() {
        return this.account;
    }

    private static enum AuthType {
        USER_PASS,
        TOKEN,
        SSH,
        NONE;

    }
}

