/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitRepo;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitJobExecutor;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class GitRepoArtifactCredentials
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitRepoArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "git/repo";
    private static final Pattern GENERIC_URL_PATTERN = Pattern.compile("^.*/(.*)$");
    private final ImmutableList<String> types = ImmutableList.of((Object)"git/repo");
    private final String name;
    private final GitJobExecutor executor;

    public GitRepoArtifactCredentials(GitJobExecutor executor) {
        this.executor = executor;
        this.name = this.executor.getAccount().getName();
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        String repoReference = artifact.getReference();
        String subPath = this.artifactSubPath(artifact);
        String remoteRef = this.artifactVersion(artifact);
        Path stagingPath = Paths.get(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        String repoBasename = this.getRepoBasename(repoReference);
        Path outputFile = Paths.get(stagingPath.toString(), repoBasename + ".tgz");
        try (Closeable ignored = () -> FileUtils.deleteDirectory((File)stagingPath.toFile());){
            this.executor.clone(repoReference, remoteRef, stagingPath);
            log.info("Creating archive for git/repo {}", (Object)repoReference);
            this.executor.archive(Paths.get(stagingPath.toString(), repoBasename), remoteRef, subPath, outputFile);
            FileInputStream fileInputStream = new FileInputStream(outputFile.toFile());
            return fileInputStream;
        }
    }

    private String getRepoBasename(String url) {
        Matcher matcher = GENERIC_URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Git repo url " + url + " doesn't match regex " + GENERIC_URL_PATTERN);
        }
        return matcher.group(1).replaceAll("\\.git$", "");
    }

    private String artifactSubPath(Artifact artifact) {
        if (!Strings.nullToEmpty((String)artifact.getLocation()).isEmpty()) {
            return artifact.getLocation();
        }
        return Strings.nullToEmpty((String)((String)artifact.getMetadata("subPath")));
    }

    private String artifactVersion(Artifact artifact) {
        return !Strings.isNullOrEmpty((String)artifact.getVersion()) ? artifact.getVersion() : "master";
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }
}

