/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.github;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.config.SimpleHttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.exceptions.FailedDownloadException;
import com.netflix.spinnaker.clouddriver.artifacts.github.GitHubArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class GitHubArtifactCredentials
extends SimpleHttpArtifactCredentials<GitHubArtifactAccount>
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitHubArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-github";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"github/file");
    @JsonIgnore
    private final ObjectMapper objectMapper;
    private final boolean useContentAPI;

    GitHubArtifactCredentials(GitHubArtifactAccount account, OkHttpClient okHttpClient, ObjectMapper objectMapper) {
        super(okHttpClient, account);
        this.name = account.getName();
        this.objectMapper = objectMapper;
        this.useContentAPI = account.isUseContentAPI();
    }

    @Override
    protected Headers getHeaders(GitHubArtifactAccount account) {
        Headers headers = super.getHeaders(account);
        if (account.isUseContentAPI()) {
            return headers.newBuilder().add("Accept", String.format("application/vnd.github.%s.raw", account.getGithubAPIVersion())).build();
        }
        return headers;
    }

    private HttpUrl getMetadataUrl(Artifact artifact) {
        String version = Strings.nullToEmpty((String)artifact.getVersion());
        if (version.isEmpty()) {
            log.info("No version specified for artifact {}, using 'master'.", (Object)version);
            version = "master";
        }
        return this.parseUrl(artifact.getReference()).newBuilder().addQueryParameter("ref", version).build();
    }

    @Override
    protected HttpUrl getDownloadUrl(Artifact artifact) throws IOException {
        ResponseBody metadataResponse;
        if (this.useContentAPI) {
            return this.getMetadataUrl(artifact);
        }
        try {
            metadataResponse = this.fetchUrl(this.getMetadataUrl(artifact));
        }
        catch (IOException e) {
            throw new FailedDownloadException("Unable to determine the download URL of artifact " + artifact + ": " + e.getMessage(), e);
        }
        ContentMetadata metadata = (ContentMetadata)this.objectMapper.readValue(metadataResponse.string(), ContentMetadata.class);
        if (Strings.isNullOrEmpty((String)metadata.downloadUrl)) {
            throw new FailedDownloadException("Failed to retrieve your github artifact's download URL. This is likely due to incorrect auth setup. Artifact: " + artifact);
        }
        return this.parseUrl(metadata.getDownloadUrl());
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }

    static class ContentMetadata {
        @JsonProperty(value="download_url")
        @Nullable
        private String downloadUrl;

        @Generated
        public ContentMetadata() {
        }

        @Nullable
        @Generated
        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        @JsonProperty(value="download_url")
        @Generated
        public ContentMetadata setDownloadUrl(@Nullable String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentMetadata)) {
                return false;
            }
            ContentMetadata other = (ContentMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$downloadUrl = this.getDownloadUrl();
            String other$downloadUrl = other.getDownloadUrl();
            return !(this$downloadUrl == null ? other$downloadUrl != null : !this$downloadUrl.equals(other$downloadUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ContentMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $downloadUrl = this.getDownloadUrl();
            result = result * 59 + ($downloadUrl == null ? 43 : $downloadUrl.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GitHubArtifactCredentials.ContentMetadata(downloadUrl=" + this.getDownloadUrl() + ")";
        }
    }
}

