/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitlab;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.config.SimpleHttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class GitlabArtifactCredentials
extends SimpleHttpArtifactCredentials<GitlabArtifactAccount>
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitlabArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-gitlab";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"gitlab/file");

    GitlabArtifactCredentials(GitlabArtifactAccount account, OkHttpClient okHttpClient) {
        super(okHttpClient, account);
        this.name = account.getName();
    }

    @Override
    protected Headers getHeaders(GitlabArtifactAccount account) {
        Headers.Builder headers = new Headers.Builder();
        Optional token = account.getTokenAsString();
        if (token.isPresent()) {
            headers.set("Private-Token", (String)token.get());
            log.info("Loaded credentials for GitLab Artifact Account {}", (Object)account.getName());
        } else {
            log.info("No credentials included with GitLab Artifact Account {}", (Object)account.getName());
        }
        return headers.build();
    }

    @Override
    protected HttpUrl getDownloadUrl(Artifact artifact) {
        String version = Strings.nullToEmpty((String)artifact.getVersion());
        if (version.isEmpty()) {
            log.info("No version specified for artifact {}, using 'master'.", (Object)version);
            version = "master";
        }
        return this.parseUrl(artifact.getReference()).newBuilder().addQueryParameter("ref", version).build();
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }
}

