/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.helm;

import com.netflix.spinnaker.clouddriver.artifacts.helm.HelmArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.helm.HelmArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.helm.HelmArtifactProviderProperties;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import com.squareup.okhttp.OkHttpClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.helm.enabled"})
@EnableConfigurationProperties(value={HelmArtifactProviderProperties.class})
class HelmArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelmArtifactConfiguration.class);
    private final HelmArtifactProviderProperties helmArtifactProviderProperties;

    @Bean
    public CredentialsTypeProperties<HelmArtifactCredentials, HelmArtifactAccount> helmCredentialsProperties(OkHttpClient okHttpClient) {
        return CredentialsTypeProperties.builder().type("artifacts-helm").credentialsClass(HelmArtifactCredentials.class).credentialsDefinitionClass(HelmArtifactAccount.class).defaultCredentialsSource(this.helmArtifactProviderProperties::getAccounts).credentialsParser(a -> {
            try {
                return new HelmArtifactCredentials((HelmArtifactAccount)a, okHttpClient);
            }
            catch (Exception e) {
                log.warn("Failure instantiating Helm artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Generated
    public HelmArtifactConfiguration(HelmArtifactProviderProperties helmArtifactProviderProperties) {
        this.helmArtifactProviderProperties = helmArtifactProviderProperties;
    }
}

