/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.ivy.settings;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.settings.Credentials;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.settings.Resolvers;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.settings.Settings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.ivy.Ivy;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.url.CredentialsStore;

@JacksonXmlRootElement(localName="ivysettings")
public final class IvySettings {
    private Resolvers resolvers = new Resolvers();
    private Settings settings = new Settings();
    @Nullable
    private Credentials credentials;

    public static IvySettings parse(String xml) {
        try {
            return (IvySettings)new XmlMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).readValue(xml, IvySettings.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read Ivy settings", e);
        }
    }

    public Ivy toIvy(Path cache) {
        return Ivy.newInstance((org.apache.ivy.core.settings.IvySettings)this.toIvySettings(cache));
    }

    org.apache.ivy.core.settings.IvySettings toIvySettings(Path cache) {
        org.apache.ivy.core.settings.IvySettings ivySettings = new org.apache.ivy.core.settings.IvySettings();
        List<DependencyResolver> dependencyResolvers = this.resolvers.toDependencyResolvers();
        if (dependencyResolvers.isEmpty()) {
            throw new IllegalArgumentException("At least one ivy resolver is required");
        }
        dependencyResolvers.forEach(arg_0 -> ((org.apache.ivy.core.settings.IvySettings)ivySettings).addResolver(arg_0));
        String defaultResolver = this.settings.getDefaultResolver();
        ivySettings.setDefaultResolver(defaultResolver == null ? dependencyResolvers.iterator().next().getName() : defaultResolver);
        if (this.credentials != null) {
            CredentialsStore.INSTANCE.addCredentials(this.credentials.getRealm(), this.credentials.getHost(), this.credentials.getUsername(), this.credentials.getPassword());
        }
        ivySettings.setDefaultCache(cache.toFile());
        ivySettings.validate();
        return ivySettings;
    }

    @Generated
    public IvySettings() {
    }

    @Generated
    public Resolvers getResolvers() {
        return this.resolvers;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Nullable
    @Generated
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public IvySettings setResolvers(Resolvers resolvers) {
        this.resolvers = resolvers;
        return this;
    }

    @Generated
    public IvySettings setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @Generated
    public IvySettings setCredentials(@Nullable Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IvySettings)) {
            return false;
        }
        IvySettings other = (IvySettings)o;
        Resolvers this$resolvers = this.getResolvers();
        Resolvers other$resolvers = other.getResolvers();
        if (this$resolvers == null ? other$resolvers != null : !((Object)this$resolvers).equals(other$resolvers)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        Credentials this$credentials = this.getCredentials();
        Credentials other$credentials = other.getCredentials();
        return !(this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Resolvers $resolvers = this.getResolvers();
        result = result * 59 + ($resolvers == null ? 43 : ((Object)$resolvers).hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        Credentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IvySettings(resolvers=" + this.getResolvers() + ", settings=" + this.getSettings() + ", credentials=" + this.getCredentials() + ")";
    }
}

