/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.kubernetes;

import com.netflix.spinnaker.clouddriver.artifacts.kubernetes.KubernetesArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.kubernetes.KubernetesArtifactCredentials;
import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.MapBackedCredentialsRepository;
import com.netflix.spinnaker.credentials.NoopCredentialsLifecycleHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"kubernetes.enabled"})
class KubernetesArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesArtifactConfiguration.class);

    @Bean
    public CredentialsRepository<KubernetesArtifactCredentials> kubernetesArtifactCredentialsRepository() {
        MapBackedCredentialsRepository repository = new MapBackedCredentialsRepository("artifacts-kubernetes", (CredentialsLifecycleHandler)new NoopCredentialsLifecycleHandler());
        repository.save((Credentials)new KubernetesArtifactCredentials(new KubernetesArtifactAccount()));
        return repository;
    }

    @Generated
    public KubernetesArtifactConfiguration() {
    }
}

