/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.oracle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactClient;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class OracleArtifactCredentials
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OracleArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-oracle";
    private static final String ARTIFACT_REFERENCE_PREFIX = "oci://";
    private static final String ARTIFACT_VERSION_QUERY_PARAM = "versionId";
    private static final String ARTIFACT_URI = "https://objectstorage.{arg0}.oraclecloud.com/n/{arg1}/b/{arg2}/o/{arg3}";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"oracle/object");
    private final String namespace;
    private final String region;
    private final String userId;
    private final String fingerprint;
    private final String sshPrivateKeyFilePath;
    private final String privateKeyPassphrase;
    private final String tenancyId;
    @JsonIgnore
    private final OracleArtifactClient client;

    OracleArtifactCredentials(String applicationName, OracleArtifactAccount account) {
        this.name = account.getName();
        this.namespace = account.getNamespace();
        this.region = account.getRegion();
        this.userId = account.getUserId();
        this.fingerprint = account.getFingerprint();
        this.sshPrivateKeyFilePath = account.getSshPrivateKeyFilePath();
        this.privateKeyPassphrase = account.getPrivateKeyPassphrase();
        this.tenancyId = account.getTenancyId();
        this.client = new OracleArtifactClient(this.userId, this.sshPrivateKeyFilePath, this.privateKeyPassphrase, this.fingerprint, this.tenancyId);
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        String fullPath;
        int slash;
        String reference = artifact.getReference();
        if (reference.startsWith(ARTIFACT_REFERENCE_PREFIX)) {
            reference = reference.substring(ARTIFACT_REFERENCE_PREFIX.length());
        }
        if ((slash = reference.indexOf("/")) <= 0) {
            throw new IllegalArgumentException("Oracle references must be of the format oci://<bucket>/<file-path>, got: " + artifact);
        }
        String bucketName = reference.substring(0, slash);
        String path = fullPath = reference.substring(slash + 1);
        UriBuilder uriBuilder = UriBuilder.fromPath((String)ARTIFACT_URI);
        int versionIndex = fullPath.indexOf("#");
        if (versionIndex > 0) {
            path = fullPath.substring(0, versionIndex);
            uriBuilder = uriBuilder.queryParam(ARTIFACT_VERSION_QUERY_PARAM, new Object[]{fullPath.substring(versionIndex + 1)});
        }
        URI uri = uriBuilder.build(new Object[]{this.region, this.namespace, bucketName, path});
        try {
            return this.client.readObject(uri);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == 404) {
                throw new IOException("Object not found (key: " + path + ")");
            }
            throw e;
        }
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }
}

