/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.s3;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class S3ArtifactAccount
implements ArtifactAccount {
    private final String name;
    private final String apiEndpoint;
    private final String apiRegion;
    private final String region;
    private final String awsAccessKeyId;
    private final String awsSecretAccessKey;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    public S3ArtifactAccount(String name, String apiEndpoint, String apiRegion, String region, String awsAccessKeyId, String awsSecretAccessKey) {
        this.name = Strings.nullToEmpty((String)name);
        this.apiEndpoint = Strings.nullToEmpty((String)apiEndpoint);
        this.apiRegion = Strings.nullToEmpty((String)apiRegion);
        this.region = Strings.nullToEmpty((String)region);
        this.awsAccessKeyId = Strings.nullToEmpty((String)awsAccessKeyId);
        this.awsSecretAccessKey = Strings.nullToEmpty((String)awsSecretAccessKey);
    }

    @Generated
    public static S3ArtifactAccountBuilder builder() {
        return new S3ArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    @Generated
    public String getApiRegion() {
        return this.apiRegion;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    @Generated
    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3ArtifactAccount)) {
            return false;
        }
        S3ArtifactAccount other = (S3ArtifactAccount)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$apiEndpoint = this.getApiEndpoint();
        String other$apiEndpoint = other.getApiEndpoint();
        if (this$apiEndpoint == null ? other$apiEndpoint != null : !this$apiEndpoint.equals(other$apiEndpoint)) {
            return false;
        }
        String this$apiRegion = this.getApiRegion();
        String other$apiRegion = other.getApiRegion();
        if (this$apiRegion == null ? other$apiRegion != null : !this$apiRegion.equals(other$apiRegion)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$awsAccessKeyId = this.getAwsAccessKeyId();
        String other$awsAccessKeyId = other.getAwsAccessKeyId();
        if (this$awsAccessKeyId == null ? other$awsAccessKeyId != null : !this$awsAccessKeyId.equals(other$awsAccessKeyId)) {
            return false;
        }
        String this$awsSecretAccessKey = this.getAwsSecretAccessKey();
        String other$awsSecretAccessKey = other.getAwsSecretAccessKey();
        return !(this$awsSecretAccessKey == null ? other$awsSecretAccessKey != null : !this$awsSecretAccessKey.equals(other$awsSecretAccessKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $apiEndpoint = this.getApiEndpoint();
        result = result * 59 + ($apiEndpoint == null ? 43 : $apiEndpoint.hashCode());
        String $apiRegion = this.getApiRegion();
        result = result * 59 + ($apiRegion == null ? 43 : $apiRegion.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $awsAccessKeyId = this.getAwsAccessKeyId();
        result = result * 59 + ($awsAccessKeyId == null ? 43 : $awsAccessKeyId.hashCode());
        String $awsSecretAccessKey = this.getAwsSecretAccessKey();
        result = result * 59 + ($awsSecretAccessKey == null ? 43 : $awsSecretAccessKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "S3ArtifactAccount(name=" + this.getName() + ", apiEndpoint=" + this.getApiEndpoint() + ", apiRegion=" + this.getApiRegion() + ", region=" + this.getRegion() + ", awsAccessKeyId=" + this.getAwsAccessKeyId() + ", awsSecretAccessKey=" + this.getAwsSecretAccessKey() + ")";
    }

    @Generated
    public static class S3ArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String apiEndpoint;
        @Generated
        private String apiRegion;
        @Generated
        private String region;
        @Generated
        private String awsAccessKeyId;
        @Generated
        private String awsSecretAccessKey;

        @Generated
        S3ArtifactAccountBuilder() {
        }

        @Generated
        public S3ArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public S3ArtifactAccountBuilder apiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        @Generated
        public S3ArtifactAccountBuilder apiRegion(String apiRegion) {
            this.apiRegion = apiRegion;
            return this;
        }

        @Generated
        public S3ArtifactAccountBuilder region(String region) {
            this.region = region;
            return this;
        }

        @Generated
        public S3ArtifactAccountBuilder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        @Generated
        public S3ArtifactAccountBuilder awsSecretAccessKey(String awsSecretAccessKey) {
            this.awsSecretAccessKey = awsSecretAccessKey;
            return this;
        }

        @Generated
        public S3ArtifactAccount build() {
            return new S3ArtifactAccount(this.name, this.apiEndpoint, this.apiRegion, this.region, this.awsAccessKeyId, this.awsSecretAccessKey);
        }

        @Generated
        public String toString() {
            return "S3ArtifactAccount.S3ArtifactAccountBuilder(name=" + this.name + ", apiEndpoint=" + this.apiEndpoint + ", apiRegion=" + this.apiRegion + ", region=" + this.region + ", awsAccessKeyId=" + this.awsAccessKeyId + ", awsSecretAccessKey=" + this.awsSecretAccessKey + ")";
        }
    }
}

