/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.InputStream;
import lombok.Generated;

@NonnullByDefault
public class S3ArtifactCredentials
implements ArtifactCredentials {
    public static final String CREDENTIALS_TYPE = "artifacts-s3";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"s3/object");
    private final String apiEndpoint;
    private final String apiRegion;
    private final String region;
    private final String awsAccessKeyId;
    private final String awsSecretAccessKey;

    S3ArtifactCredentials(S3ArtifactAccount account) throws IllegalArgumentException {
        this.name = account.getName();
        this.apiEndpoint = account.getApiEndpoint();
        this.apiRegion = account.getApiRegion();
        this.region = account.getRegion();
        this.awsAccessKeyId = account.getAwsAccessKeyId();
        this.awsSecretAccessKey = account.getAwsSecretAccessKey();
    }

    private AmazonS3 getS3Client() {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (!this.apiEndpoint.isEmpty()) {
            AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(this.apiEndpoint, this.apiRegion);
            builder.setEndpointConfiguration(endpoint);
            builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        } else if (!this.region.isEmpty()) {
            builder.setRegion(this.region);
        }
        if (!this.awsAccessKeyId.isEmpty() && !this.awsSecretAccessKey.isEmpty()) {
            BasicAWSCredentials awsStaticCreds = new BasicAWSCredentials(this.awsAccessKeyId, this.awsSecretAccessKey);
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsStaticCreds));
        }
        return (AmazonS3)builder.build();
    }

    @Override
    public InputStream download(Artifact artifact) throws IllegalArgumentException {
        int slash;
        String reference = artifact.getReference();
        if (reference.startsWith("s3://")) {
            reference = reference.substring("s3://".length());
        }
        if ((slash = reference.indexOf("/")) <= 0) {
            throw new IllegalArgumentException("S3 references must be of the format s3://<bucket>/<file-path>, got: " + artifact);
        }
        String bucketName = reference.substring(0, slash);
        String path = reference.substring(slash + 1);
        S3Object s3obj = this.getS3Client().getObject(bucketName, path);
        return s3obj.getObjectContent();
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }
}

