/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.CredentialsTypeBaseConfiguration;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Configuration
@EnableConfigurationProperties
@EnableScheduling
@Component
@ComponentScan(value={"com.netflix.spinnaker.clouddriver.artifacts"})
public class ArtifactConfiguration {
    @Bean
    OkHttpClient okHttpClient() {
        return new OkHttpClient();
    }

    @Bean
    public ArtifactCredentialsRepository artifactCredentialsRepository(ApplicationContext applicationContext, List<CredentialsTypeProperties<? extends ArtifactCredentials, ? extends ArtifactAccount>> credentialsTypes, List<CredentialsRepository<? extends ArtifactCredentials>> defaultRepositories) {
        List<CredentialsRepository<? extends ArtifactCredentials>> repositories = credentialsTypes.stream().map(c -> new CredentialsTypeBaseConfiguration(applicationContext, c)).peek(CredentialsTypeBaseConfiguration::afterPropertiesSet).map(CredentialsTypeBaseConfiguration::getCredentialsRepository).collect(Collectors.toList());
        repositories.addAll(defaultRepositories);
        return new ArtifactCredentialsRepository(repositories);
    }
}

