/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth;

import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.DockerUserAgent;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerToken;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.exception.DockerRegistryAuthenticationException;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RestAdapter;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.Path;
import retrofit.http.Query;

public class DockerBearerTokenService
implements GroovyObject {
    private Map<String, TokenService> realmToService;
    private Map<String, DockerBearerToken> cachedTokens;
    private String username;
    private String password;
    private File passwordFile;
    private String authWarning;
    private static final String userAgent;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DockerBearerTokenService() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(HashMap.class);
        this.realmToService = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        Object object2 = callSiteArray[1].callConstructor(HashMap.class);
        this.cachedTokens = (Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class);
    }

    public DockerBearerTokenService(String username, String password) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this();
        String string = username;
        this.username = ShortTypeHandling.castToString((Object)string);
        String string2 = password;
        this.password = ShortTypeHandling.castToString((Object)string2);
    }

    public DockerBearerTokenService(String username, File passwordFile) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this();
        String string = username;
        this.username = ShortTypeHandling.castToString((Object)string);
        File file = passwordFile;
        this.passwordFile = (File)ScriptBytecodeAdapter.castToType((Object)file, File.class);
    }

    public String getBasicAuth() {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        if (!(DefaultTypeTransformation.booleanUnbox((Object)this.username) || DefaultTypeTransformation.booleanUnbox((Object)this.password) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile))) {
            return ShortTypeHandling.castToString(null);
        }
        Object resolvedPassword = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)this.password)) {
            String string = this.password;
            resolvedPassword = string;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile)) {
            Object object;
            resolvedPassword = object = callSiteArray[2].call(callSiteArray[3].callConstructor(BufferedReader.class, callSiteArray[4].callConstructor(FileReader.class, (Object)this.passwordFile)));
        } else {
            String string = "";
            resolvedPassword = string;
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[5].callSafe(resolvedPassword), (Object)0)) {
            String message = "Your registry password has %s whitespace, if this is unintentional authentication will fail.";
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].call(resolvedPassword, (Object)0)))) {
                Object object = callSiteArray[8].callCurrent((GroovyObject)this, (Object)message, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"leading"}));
                this.authWarning = ShortTypeHandling.castToString((Object)object);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(callSiteArray[10].call(resolvedPassword, callSiteArray[11].call(callSiteArray[12].call(resolvedPassword), (Object)1))))) {
                Object object = callSiteArray[13].callCurrent((GroovyObject)this, (Object)message, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"trailing"}));
                this.authWarning = ShortTypeHandling.castToString((Object)object);
            }
        }
        Object basicAuth = callSiteArray[14].callConstructor(String.class, callSiteArray[15].call(callSiteArray[16].callGetProperty(Base64.class), callSiteArray[17].callGroovyObjectGetProperty((Object)new GStringImpl(new Object[]{this.username, resolvedPassword}, new String[]{"", ":", ""}))));
        return ShortTypeHandling.castToString((Object)basicAuth);
    }

    public String getBasicAuthHeader() {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object basicAuth = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            basicAuth = object = callSiteArray[18].callCurrent((GroovyObject)this);
        } else {
            String string = this.getBasicAuth();
            basicAuth = string;
        }
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)basicAuth) ? new GStringImpl(new Object[]{basicAuth}, new String[]{"Basic ", ""}) : null));
    }

    public AuthenticateDetails parseBearerAuthenticateHeader(String header) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        String realmKey = "realm";
        String serviceKey = "service";
        String scopeKey = "scope";
        AuthenticateDetails result = (AuthenticateDetails)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callConstructor(AuthenticateDetails.class, (Object)this), AuthenticateDetails.class);
        while (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[20].call((Object)header), (Object)0)) {
            String key = null;
            String value = null;
            Object keyEnd = callSiteArray[21].call((Object)header, (Object)"=");
            if (ScriptBytecodeAdapter.compareEqual((Object)keyEnd, (Object)-1)) {
                throw (Throwable)callSiteArray[22].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{header}, new String[]{"Www-Authenticate header terminated with junk: '", "'."}));
            }
            Object object = callSiteArray[23].call((Object)header, (Object)0, keyEnd);
            key = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[24].call((Object)header, callSiteArray[25].call(keyEnd, (Object)1));
            header = ShortTypeHandling.castToString((Object)object2);
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[26].call((Object)header), (Object)0)) {
                throw (Throwable)callSiteArray[27].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{key}, new String[]{"Www-Authenticate header unmatched parameter key: '", "'."}));
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[28].call((Object)header, (Object)0), (Object)"\"")) {
                Object object3 = callSiteArray[29].call((Object)header, (Object)1);
                header = ShortTypeHandling.castToString((Object)object3);
                Object valueEnd = callSiteArray[30].call((Object)header, (Object)"\"");
                if (ScriptBytecodeAdapter.compareEqual((Object)valueEnd, (Object)-1)) {
                    throw (Throwable)callSiteArray[31].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header has unterminated \" (quotation mark).");
                }
                Object object4 = callSiteArray[32].call((Object)header, (Object)0, valueEnd);
                value = ShortTypeHandling.castToString((Object)object4);
                Object object5 = callSiteArray[33].call((Object)header, callSiteArray[34].call(valueEnd, (Object)1));
                header = ShortTypeHandling.castToString((Object)object5);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[35].call((Object)header), (Object)0)) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[36].call((Object)header, (Object)0), (Object)",")) {
                        throw (Throwable)callSiteArray[37].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header params must be separated by , (comma).");
                    }
                    Object object6 = callSiteArray[38].call((Object)header, (Object)1);
                    header = ShortTypeHandling.castToString((Object)object6);
                }
            } else {
                Object valueEnd = callSiteArray[39].call((Object)header, (Object)",");
                if (ScriptBytecodeAdapter.compareEqual((Object)valueEnd, (Object)-1)) {
                    String string;
                    String string2;
                    value = string2 = header;
                    header = string = "";
                } else {
                    Object object7 = callSiteArray[40].call((Object)header, (Object)0, valueEnd);
                    value = ShortTypeHandling.castToString((Object)object7);
                    Object object8 = callSiteArray[41].call((Object)header, callSiteArray[42].call(valueEnd, (Object)1));
                    header = ShortTypeHandling.castToString((Object)object8);
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call((Object)key, (Object)realmKey))) {
                Object url = callSiteArray[44].callConstructor(URL.class, (Object)value);
                Object object9 = callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].callGetProperty(url), (Object)"://"), callSiteArray[48].callGetProperty(url));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object9, DockerBearerTokenService.class, (GroovyObject)result, (String)"realm");
                Object object10 = callSiteArray[49].callGetProperty(url);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object10, DockerBearerTokenService.class, (GroovyObject)result, (String)"path");
                if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[50].call(callSiteArray[51].callGroovyObjectGetProperty((Object)result)), (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[52].call(callSiteArray[53].callGroovyObjectGetProperty((Object)result), (Object)0), (Object)"/"))) continue;
                Object object11 = callSiteArray[54].call(callSiteArray[55].callGroovyObjectGetProperty((Object)result), (Object)1);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object11, DockerBearerTokenService.class, (GroovyObject)result, (String)"path");
                continue;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].call((Object)key, (Object)serviceKey))) {
                String string = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, DockerBearerTokenService.class, (GroovyObject)result, (String)"service");
                continue;
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].call((Object)key, (Object)scopeKey))) continue;
            String string = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, DockerBearerTokenService.class, (GroovyObject)result, (String)"scope");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].callGroovyObjectGetProperty((Object)result))) {
            throw (Throwable)callSiteArray[59].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header must provide 'realm' parameter.");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].callGroovyObjectGetProperty((Object)result))) {
            throw (Throwable)callSiteArray[61].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header must provide 'service' parameter.");
        }
        return result;
    }

    private Object getTokenService(String realm) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object tokenService = callSiteArray[62].call(this.realmToService, (Object)realm);
        if (ScriptBytecodeAdapter.compareEqual((Object)tokenService, null)) {
            Object object;
            Object builder = callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].callConstructor(RestAdapter.Builder.class), (Object)realm), callSiteArray[67].callGetProperty(RestAdapter.LogLevel.class)));
            tokenService = object = callSiteArray[68].call(builder, TokenService.class);
            Object object2 = tokenService;
            callSiteArray[69].call(this.realmToService, (Object)realm, object2);
        }
        return tokenService;
    }

    public DockerBearerToken getToken(String repository) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return (DockerBearerToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call(this.cachedTokens, (Object)repository), DockerBearerToken.class);
    }

    public DockerBearerToken getToken(String repository, String authenticateHeader) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object authenticateDetails = null;
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object;
                authenticateDetails = object = callSiteArray[71].callCurrent((GroovyObject)this, (Object)authenticateHeader);
            } else {
                AuthenticateDetails authenticateDetails2 = this.parseBearerAuthenticateHeader(authenticateHeader);
                authenticateDetails = authenticateDetails2;
            }
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[72].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[73].callGetProperty((Object)e)}, new String[]{"Failed to parse www-authenticate header: ", ""}));
        }
        Object tokenService = callSiteArray[74].callCurrent((GroovyObject)this, callSiteArray[75].callGetProperty(authenticateDetails));
        Object token = null;
        try {
            Object object;
            Object object2;
            token = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].callGroovyObjectGetProperty((Object)this)) ? (object2 = callSiteArray[77].call(tokenService, ArrayUtil.createArray((Object)callSiteArray[78].callGetProperty(authenticateDetails), (Object)callSiteArray[79].callGetProperty(authenticateDetails), (Object)callSiteArray[80].callGetProperty(authenticateDetails), (Object)callSiteArray[81].callGroovyObjectGetProperty((Object)this), (Object)userAgent))) : (object = callSiteArray[82].call(tokenService, callSiteArray[83].callGetProperty(authenticateDetails), callSiteArray[84].callGetProperty(authenticateDetails), callSiteArray[85].callGetProperty(authenticateDetails), (Object)userAgent));
        }
        catch (Exception e) {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.authWarning)) {
                throw (Throwable)callSiteArray[86].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{this.authWarning, callSiteArray[87].call((Object)e)}, new String[]{"Authentication failed (", "): ", ""}), (Object)e);
            }
            throw (Throwable)callSiteArray[88].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[89].call((Object)e)}, new String[]{"Authentication failed: ", ""}), (Object)e);
        }
        Object object = token;
        callSiteArray[90].call(this.cachedTokens, (Object)repository, object);
        return (DockerBearerToken)ScriptBytecodeAdapter.castToType((Object)token, DockerBearerToken.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerBearerTokenService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = DockerBearerTokenService.$getCallSiteArray()[91].call(DockerUserAgent.class);
        userAgent = ShortTypeHandling.castToString((Object)object);
        Object object2 = DockerBearerTokenService.$getCallSiteArray()[92].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerTokenService");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    public Map<String, TokenService> getRealmToService() {
        return this.realmToService;
    }

    public void setRealmToService(Map<String, TokenService> map) {
        this.realmToService = map;
    }

    public Map<String, DockerBearerToken> getCachedTokens() {
        return this.cachedTokens;
    }

    public void setCachedTokens(Map<String, DockerBearerToken> map) {
        this.cachedTokens = map;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(File file) {
        this.passwordFile = file;
    }

    public String getAuthWarning() {
        return this.authWarning;
    }

    public void setAuthWarning(String string) {
        this.authWarning = string;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "getText";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "length";
        stringArray[6] = "isWhitespace";
        stringArray[7] = "charAt";
        stringArray[8] = "sprintf";
        stringArray[9] = "isWhitespace";
        stringArray[10] = "charAt";
        stringArray[11] = "minus";
        stringArray[12] = "length";
        stringArray[13] = "sprintf";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "encode";
        stringArray[16] = "encoder";
        stringArray[17] = "bytes";
        stringArray[18] = "getBasicAuth";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "length";
        stringArray[21] = "indexOf";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "substring";
        stringArray[24] = "substring";
        stringArray[25] = "plus";
        stringArray[26] = "length";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "getAt";
        stringArray[29] = "substring";
        stringArray[30] = "indexOf";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "substring";
        stringArray[33] = "substring";
        stringArray[34] = "plus";
        stringArray[35] = "length";
        stringArray[36] = "getAt";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "substring";
        stringArray[39] = "indexOf";
        stringArray[40] = "substring";
        stringArray[41] = "substring";
        stringArray[42] = "plus";
        stringArray[43] = "equalsIgnoreCase";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "protocol";
        stringArray[48] = "authority";
        stringArray[49] = "path";
        stringArray[50] = "length";
        stringArray[51] = "path";
        stringArray[52] = "getAt";
        stringArray[53] = "path";
        stringArray[54] = "substring";
        stringArray[55] = "path";
        stringArray[56] = "equalsIgnoreCase";
        stringArray[57] = "equalsIgnoreCase";
        stringArray[58] = "realm";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "service";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "get";
        stringArray[63] = "build";
        stringArray[64] = "setLogLevel";
        stringArray[65] = "setEndpoint";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "NONE";
        stringArray[68] = "create";
        stringArray[69] = "putAt";
        stringArray[70] = "getAt";
        stringArray[71] = "parseBearerAuthenticateHeader";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "message";
        stringArray[74] = "getTokenService";
        stringArray[75] = "realm";
        stringArray[76] = "basicAuthHeader";
        stringArray[77] = "getToken";
        stringArray[78] = "path";
        stringArray[79] = "service";
        stringArray[80] = "scope";
        stringArray[81] = "basicAuthHeader";
        stringArray[82] = "getToken";
        stringArray[83] = "path";
        stringArray[84] = "service";
        stringArray[85] = "scope";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "getMessage";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "getMessage";
        stringArray[90] = "putAt";
        stringArray[91] = "getUserAgent";
        stringArray[92] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[93];
        DockerBearerTokenService.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DockerBearerTokenService.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DockerBearerTokenService.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    interface TokenService {
        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public DockerBearerToken getToken(@Path(encode=false, value="path") String var1, @Query(value="service") String var2, @Query(value="scope") String var3, @Header(value="User-Agent") String var4);

        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public DockerBearerToken getToken(@Path(encode=false, value="path") String var1, @Query(value="service") String var2, @Query(value="scope") String var3, @Header(value="Authorization") String var4, @Header(value="User-Agent") String var5);
    }

    class AuthenticateDetails
    implements GroovyObject {
        private String realm;
        private String path;
        private String service;
        private String scope;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        public /* synthetic */ DockerBearerTokenService this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public AuthenticateDetails(DockerBearerTokenService $p$) {
            MetaClass metaClass;
            DockerBearerTokenService dockerBearerTokenService;
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            this.this$0 = dockerBearerTokenService = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AuthenticateDetails.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AuthenticateDetails.class, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AuthenticateDetails.class, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String string) {
            this.realm = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String string) {
            this.service = string;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String string) {
            this.scope = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AuthenticateDetails.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AuthenticateDetails.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

