/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryClient;
import com.netflix.spinnaker.clouddriver.docker.registry.exception.DockerRegistryConfigException;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RetrofitError;

public class DockerRegistryNamedAccountCredentials
implements AccountCredentials<DockerRegistryCredentials>,
GroovyObject {
    private static final String CLOUD_PROVIDER = "dockerRegistry";
    private final String accountName;
    private final String environment;
    private final String accountType;
    private final String address;
    private final String registry;
    @JsonIgnore
    private final String username;
    @JsonIgnore
    private final String password;
    private final File passwordFile;
    private final String email;
    private final boolean trackDigests;
    private final boolean sortTagsByDate;
    private final int cacheThreads;
    private final long cacheIntervalSeconds;
    private final long clientTimeoutMillis;
    private final int paginateSize;
    private final boolean insecureRegistry;
    @JsonIgnore
    private final DockerRegistryCredentials credentials;
    private final List<String> requiredGroupMembership;
    private final List<String> skip;
    private final String catalogFile;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DockerRegistryNamedAccountCredentials(String accountName, String environment, String accountType, String address, String username, String password, File passwordFile, File dockerconfigFile, String email, List<String> repositories, List<String> skip, int cacheThreads, long cacheIntervalSeconds, long clientTimeoutMillis, int paginateSize, boolean trackDigests, boolean sortTagsByDate, String catalogFile, boolean insecureRegistry) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        this(accountName, environment, accountType, address, username, password, passwordFile, dockerconfigFile, email, repositories, skip, cacheThreads, cacheIntervalSeconds, clientTimeoutMillis, paginateSize, trackDigests, sortTagsByDate, catalogFile, insecureRegistry, null);
    }

    public DockerRegistryNamedAccountCredentials(String accountName, String environment, String accountType, String address, String username, String password, File passwordFile, File dockerconfigFile, String email, List<String> repositories, List<String> skip, int cacheThreads, long cacheIntervalSeconds, long clientTimeoutMillis, int paginateSize, boolean trackDigests, boolean sortTagsByDate, String catalogFile, boolean insecureRegistry, List<String> requiredGroupMembership) {
        MetaClass metaClass;
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!DefaultTypeTransformation.booleanUnbox((Object)accountName)) {
            throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"Docker Registry account must be provided with a name.");
        }
        if (DefaultTypeTransformation.booleanUnbox(repositories) && DefaultTypeTransformation.booleanUnbox((Object)catalogFile)) {
            throw (Throwable)callSiteArray[1].callConstructor(IllegalArgumentException.class, (Object)"repositories and catalogFile may not be specified together.");
        }
        String string = accountName;
        this.accountName = ShortTypeHandling.castToString((Object)string);
        String string2 = environment;
        this.environment = ShortTypeHandling.castToString((Object)string2);
        String string3 = accountType;
        this.accountType = ShortTypeHandling.castToString((Object)string3);
        File file = passwordFile;
        this.passwordFile = (File)ScriptBytecodeAdapter.castToType((Object)file, File.class);
        int n = cacheThreads;
        int n2 = n != 0 ? n : 1;
        this.cacheThreads = DefaultTypeTransformation.intUnbox((Object)n2);
        long l = cacheIntervalSeconds;
        long l2 = l != 0L ? l : (long)30;
        this.cacheIntervalSeconds = DefaultTypeTransformation.longUnbox((Object)l2);
        int n3 = paginateSize;
        int n4 = n3 != 0 ? n3 : 100;
        this.paginateSize = DefaultTypeTransformation.intUnbox((Object)n4);
        long l3 = clientTimeoutMillis;
        Long l4 = l3 != 0L ? Long.valueOf(l3) : callSiteArray[2].call(callSiteArray[3].callGetProperty(TimeUnit.class), (Object)1);
        this.clientTimeoutMillis = DefaultTypeTransformation.longUnbox((Object)l4);
        if (!DefaultTypeTransformation.booleanUnbox((Object)address)) {
            throw (Throwable)callSiteArray[4].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{accountName}, new String[]{"Docker Registry account ", " must provide an endpoint address."}));
        }
        int addressLen = DefaultTypeTransformation.intUnbox((Object)callSiteArray[5].call((Object)address));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call((Object)address, callSiteArray[7].call((Object)addressLen, (Object)1)), (Object)"/")) {
                Object object = callSiteArray[8].call((Object)address, (Object)0, callSiteArray[9].call((Object)addressLen, (Object)1));
                address = ShortTypeHandling.castToString((Object)object);
                addressLen = DefaultTypeTransformation.intUnbox((Object)callSiteArray[10].call((Object)addressLen, (Object)1));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[11].call((Object)address, (Object)(addressLen - 1)), (Object)"/")) {
            Object object = callSiteArray[12].call((Object)address, (Object)0, (Object)(addressLen - 1));
            address = ShortTypeHandling.castToString((Object)object);
            addressLen = addressLen - 1;
        }
        if (!BytecodeInterface8.isOrigInt() || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)address, (Object)"/v2"))) {
                Object object = callSiteArray[14].call((Object)address, (Object)0, callSiteArray[15].call((Object)addressLen, (Object)3));
                address = ShortTypeHandling.castToString((Object)object);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call((Object)address, (Object)"/v2"))) {
            Object object = callSiteArray[17].call((Object)address, (Object)0, (Object)(addressLen - 3));
            address = ShortTypeHandling.castToString((Object)object);
        }
        String string4 = address;
        this.address = ShortTypeHandling.castToString((Object)string4);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].call((Object)address, (Object)"https://"))) {
            Object object = callSiteArray[19].call((Object)address, callSiteArray[20].call((Object)"https://"));
            this.registry = ShortTypeHandling.castToString((Object)object);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call((Object)address, (Object)"http://"))) {
            Object object = callSiteArray[22].call((Object)address, callSiteArray[23].call((Object)"http://"));
            this.registry = ShortTypeHandling.castToString((Object)object);
        } else {
            String string5 = address;
            this.registry = ShortTypeHandling.castToString((Object)string5);
        }
        String string6 = username;
        this.username = ShortTypeHandling.castToString((Object)string6);
        String string7 = password;
        this.password = ShortTypeHandling.castToString((Object)string7);
        String string8 = email;
        this.email = ShortTypeHandling.castToString((Object)string8);
        boolean bl = trackDigests;
        this.trackDigests = DefaultTypeTransformation.booleanUnbox((Object)bl);
        boolean bl2 = sortTagsByDate;
        this.sortTagsByDate = DefaultTypeTransformation.booleanUnbox((Object)bl2);
        boolean bl3 = insecureRegistry;
        this.insecureRegistry = DefaultTypeTransformation.booleanUnbox((Object)bl3);
        List list = skip;
        List list2 = DefaultTypeTransformation.booleanUnbox(list) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.skip = (List)ScriptBytecodeAdapter.castToType((Object)list2, List.class);
        Object object = ScriptBytecodeAdapter.compareEqual(requiredGroupMembership, null) ? callSiteArray[24].call(Collections.class) : callSiteArray[25].call(Collections.class, requiredGroupMembership);
        this.requiredGroupMembership = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        Object object2 = callSiteArray[26].callCurrent((GroovyObject)this, repositories, (Object)catalogFile);
        this.credentials = (DockerRegistryCredentials)ScriptBytecodeAdapter.castToType((Object)object2, DockerRegistryCredentials.class);
    }

    @JsonIgnore
    public List<String> getRepositories() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callGroovyObjectGetProperty((Object)this.credentials), List.class);
    }

    public String getName() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return this.accountName;
    }

    @JsonIgnore
    public String getBasicAuth() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        Object object = callSiteArray[28].callGetPropertySafe(callSiteArray[29].callGetPropertySafe((Object)this.credentials));
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ""));
    }

    @JsonIgnore
    public List<String> getTags(String repository) {
        Reference repository2 = new Reference((Object)repository);
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        Object tags = callSiteArray[30].callGetProperty(callSiteArray[31].call(callSiteArray[32].callGroovyObjectGetProperty((Object)this.credentials), (Object)((String)repository2.get())));
        if (this.sortTagsByDate) {
            Object object;
            public class _getTags_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference repository;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getTags_closure1(Object _outerInstance, Object _thisObject, Reference repository) {
                    Reference reference;
                    CallSite[] callSiteArray = _getTags_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.repository = reference = repository;
                }

                public Object doCall(Object tag) {
                    CallSite[] callSiteArray = _getTags_closure1.$getCallSiteArray();
                    Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"date", callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty(callSiteArray[2].callGroovyObjectGetProperty((Object)this)), this.repository.get(), tag), "tag", tag});
                    try {
                        return map;
                    }
                    catch (Exception e) {
                        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(DockerRegistryNamedAccountCredentials.class))) ? callSiteArray[5].call(callSiteArray[6].callGetProperty(DockerRegistryNamedAccountCredentials.class), (Object)"Unable to fetch tag creation date, reason: {} (tag: {}, repository: {})", callSiteArray[7].callGetProperty((Object)e), tag, this.repository.get()) : null;
                        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"date", callSiteArray[8].callConstructor(Date.class, (Object)0), "tag", tag});
                        return map2;
                    }
                }

                public String getRepository() {
                    CallSite[] callSiteArray = _getTags_closure1.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.repository.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getTags_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getCreationDate";
                    stringArray[1] = "client";
                    stringArray[2] = "credentials";
                    stringArray[3] = "isWarnEnabled";
                    stringArray[4] = "log";
                    stringArray[5] = "warn";
                    stringArray[6] = "log";
                    stringArray[7] = "message";
                    stringArray[8] = "<$constructor$>";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[9];
                    _getTags_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getTags_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getTags_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public class _getTags_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getTags_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _getTags_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getTags_closure2.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(it);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getTags_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getTags_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "date";
                    return new CallSiteArray(_getTags_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getTags_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            tags = object = callSiteArray[33].callGetProperty(callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(tags), (Object)new _getTags_closure1(this, this, repository2))), (Object)new _getTags_closure2(this, this))));
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)tags, List.class);
    }

    public String getV2Endpoint() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.address}, new String[]{"", "/v2"}));
    }

    public String getCloudProvider() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return CLOUD_PROVIDER;
    }

    private DockerRegistryCredentials buildCredentials(List<String> repositories, String catalogFile) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        DockerRegistryClient client = (DockerRegistryClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].callConstructor(DockerRegistryClient.Builder.class), (Object)this.address), (Object)this.email), (Object)this.username), (Object)this.password), (Object)this.passwordFile), (Object)this.clientTimeoutMillis), (Object)this.paginateSize), (Object)catalogFile), (Object)this.insecureRegistry)), DockerRegistryClient.class);
        DockerRegistryCredentials dockerRegistryCredentials = (DockerRegistryCredentials)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callConstructor(DockerRegistryCredentials.class, ArrayUtil.createArray((Object)client, repositories, (Object)this.trackDigests, this.skip, (Object)this.sortTagsByDate)), DockerRegistryCredentials.class);
        try {
            return dockerRegistryCredentials;
        }
        catch (RetrofitError e) {
            block6: {
                if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[51].callGetPropertySafe(callSiteArray[52].callGetProperty((Object)e)), (Object)404)) break block6;
                throw (Throwable)callSiteArray[53].callConstructor(DockerRegistryConfigException.class, (Object)new GStringImpl(new Object[]{callSiteArray[54].callGroovyObjectGetProperty((Object)this), this.address}, new String[]{"No repositories specified for ", ", and the provided endpoint ", " does not support /_catalog."}));
            }
            throw (Throwable)e;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerRegistryNamedAccountCredentials.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = DockerRegistryNamedAccountCredentials.$getCallSiteArray()[55].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public final String getAccountName() {
        return this.accountName;
    }

    public final String getEnvironment() {
        return this.environment;
    }

    public final String getAccountType() {
        return this.accountType;
    }

    public final String getAddress() {
        return this.address;
    }

    public final String getRegistry() {
        return this.registry;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final File getPasswordFile() {
        return this.passwordFile;
    }

    public final String getEmail() {
        return this.email;
    }

    public final boolean getTrackDigests() {
        return this.trackDigests;
    }

    public final boolean isTrackDigests() {
        return this.trackDigests;
    }

    public final boolean getSortTagsByDate() {
        return this.sortTagsByDate;
    }

    public final boolean isSortTagsByDate() {
        return this.sortTagsByDate;
    }

    public final int getCacheThreads() {
        return this.cacheThreads;
    }

    public final long getCacheIntervalSeconds() {
        return this.cacheIntervalSeconds;
    }

    public final long getClientTimeoutMillis() {
        return this.clientTimeoutMillis;
    }

    public final int getPaginateSize() {
        return this.paginateSize;
    }

    public final boolean getInsecureRegistry() {
        return this.insecureRegistry;
    }

    public final boolean isInsecureRegistry() {
        return this.insecureRegistry;
    }

    public final DockerRegistryCredentials getCredentials() {
        return this.credentials;
    }

    public final List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    public final List<String> getSkip() {
        return this.skip;
    }

    public final String getCatalogFile() {
        return this.catalogFile;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "toMillis";
        stringArray[3] = "MINUTES";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "length";
        stringArray[6] = "getAt";
        stringArray[7] = "minus";
        stringArray[8] = "substring";
        stringArray[9] = "minus";
        stringArray[10] = "minus";
        stringArray[11] = "getAt";
        stringArray[12] = "substring";
        stringArray[13] = "endsWith";
        stringArray[14] = "substring";
        stringArray[15] = "minus";
        stringArray[16] = "endsWith";
        stringArray[17] = "substring";
        stringArray[18] = "startsWith";
        stringArray[19] = "substring";
        stringArray[20] = "length";
        stringArray[21] = "startsWith";
        stringArray[22] = "substring";
        stringArray[23] = "length";
        stringArray[24] = "emptyList";
        stringArray[25] = "unmodifiableList";
        stringArray[26] = "buildCredentials";
        stringArray[27] = "repositories";
        stringArray[28] = "basicAuth";
        stringArray[29] = "client";
        stringArray[30] = "tags";
        stringArray[31] = "getTags";
        stringArray[32] = "client";
        stringArray[33] = "tag";
        stringArray[34] = "reverse";
        stringArray[35] = "sort";
        stringArray[36] = "toArray";
        stringArray[37] = "map";
        stringArray[38] = "parallelStream";
        stringArray[39] = "build";
        stringArray[40] = "insecureRegistry";
        stringArray[41] = "catalogFile";
        stringArray[42] = "paginateSize";
        stringArray[43] = "clientTimeoutMillis";
        stringArray[44] = "passwordFile";
        stringArray[45] = "password";
        stringArray[46] = "username";
        stringArray[47] = "email";
        stringArray[48] = "address";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "status";
        stringArray[52] = "response";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "name";
        stringArray[55] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[56];
        DockerRegistryNamedAccountCredentials.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DockerRegistryNamedAccountCredentials.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DockerRegistryNamedAccountCredentials.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class Builder
    implements GroovyObject {
        private String accountName;
        private String environment;
        private String accountType;
        private String address;
        private String username;
        private String password;
        private File passwordFile;
        private File dockerconfigFile;
        private String email;
        private int cacheThreads;
        private long cacheIntervalSeconds;
        private long clientTimeoutMillis;
        private int paginateSize;
        private boolean trackDigests;
        private boolean sortTagsByDate;
        private boolean insecureRegistry;
        private List<String> repositories;
        private List<String> skip;
        private String catalogFile;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public Builder() {
            MetaClass metaClass;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Builder accountName(String accountName) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = accountName;
            this.accountName = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder environment(String environment) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = environment;
            this.environment = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder accountType(String accountType) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = accountType;
            this.accountType = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder address(String address) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = address;
            this.address = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder username(String username) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = username;
            this.username = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder password(String address) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = address;
            this.password = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder passwordFile(String passwordFile) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)passwordFile)) {
                Object object = callSiteArray[0].callConstructor(File.class, (Object)passwordFile);
                this.passwordFile = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
            } else {
                Object var4_4 = null;
                this.passwordFile = (File)ScriptBytecodeAdapter.castToType(var4_4, File.class);
            }
            return this;
        }

        public Builder dockerconfigFile(String dockerconfigFile) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)dockerconfigFile)) {
                Object object = callSiteArray[1].callConstructor(File.class, (Object)dockerconfigFile);
                this.dockerconfigFile = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
            } else {
                Object var4_4 = null;
                this.dockerconfigFile = (File)ScriptBytecodeAdapter.castToType(var4_4, File.class);
            }
            return this;
        }

        public Builder email(String email) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = email;
            this.email = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder cacheThreads(int cacheThreads) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            int n = cacheThreads;
            this.cacheThreads = DefaultTypeTransformation.intUnbox((Object)n);
            return this;
        }

        public Builder cacheIntervalSeconds(long cacheIntervalSeconds) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            long l = cacheIntervalSeconds;
            this.cacheIntervalSeconds = DefaultTypeTransformation.longUnbox((Object)l);
            return this;
        }

        public Builder clientTimeoutMillis(long clientTimeoutMillis) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            long l = clientTimeoutMillis;
            this.clientTimeoutMillis = DefaultTypeTransformation.longUnbox((Object)l);
            return this;
        }

        public Builder paginateSize(int paginateSize) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            int n = paginateSize;
            this.paginateSize = DefaultTypeTransformation.intUnbox((Object)n);
            return this;
        }

        public Builder trackDigests(boolean trackDigests) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            boolean bl = trackDigests;
            this.trackDigests = DefaultTypeTransformation.booleanUnbox((Object)bl);
            return this;
        }

        public Builder sortTagsByDate(boolean sortTagsByDate) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            boolean bl = sortTagsByDate;
            this.sortTagsByDate = DefaultTypeTransformation.booleanUnbox((Object)bl);
            return this;
        }

        public Builder insecureRegistry(boolean insecureRegistry) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            boolean bl = insecureRegistry;
            this.insecureRegistry = DefaultTypeTransformation.booleanUnbox((Object)bl);
            return this;
        }

        public Builder repositories(List<String> repositories) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            List<String> list = repositories;
            this.repositories = (List)ScriptBytecodeAdapter.castToType(list, List.class);
            return this;
        }

        public Builder skip(List<String> skip) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            List<String> list = skip;
            this.skip = (List)ScriptBytecodeAdapter.castToType(list, List.class);
            return this;
        }

        public Builder catalogFile(String catalogFile) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = catalogFile;
            this.catalogFile = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public DockerRegistryNamedAccountCredentials build() {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return (DockerRegistryNamedAccountCredentials)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(DockerRegistryNamedAccountCredentials.class, ArrayUtil.createArray((Object)this.accountName, (Object)this.environment, (Object)this.accountType, (Object)this.address, (Object)this.username, (Object)this.password, (Object)this.passwordFile, (Object)this.dockerconfigFile, (Object)this.email, this.repositories, this.skip, (Object)this.cacheThreads, (Object)this.cacheIntervalSeconds, (Object)this.clientTimeoutMillis, (Object)this.paginateSize, (Object)this.trackDigests, (Object)this.sortTagsByDate, (Object)this.catalogFile, (Object)this.insecureRegistry)), DockerRegistryNamedAccountCredentials.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Builder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String string) {
            this.accountName = string;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(String string) {
            this.environment = string;
        }

        public String getAccountType() {
            return this.accountType;
        }

        public void setAccountType(String string) {
            this.accountType = string;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String string) {
            this.address = string;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String string) {
            this.username = string;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public File getPasswordFile() {
            return this.passwordFile;
        }

        public void setPasswordFile(File file) {
            this.passwordFile = file;
        }

        public File getDockerconfigFile() {
            return this.dockerconfigFile;
        }

        public void setDockerconfigFile(File file) {
            this.dockerconfigFile = file;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String string) {
            this.email = string;
        }

        public int getCacheThreads() {
            return this.cacheThreads;
        }

        public void setCacheThreads(int n) {
            this.cacheThreads = n;
        }

        public long getCacheIntervalSeconds() {
            return this.cacheIntervalSeconds;
        }

        public void setCacheIntervalSeconds(long l) {
            this.cacheIntervalSeconds = l;
        }

        public long getClientTimeoutMillis() {
            return this.clientTimeoutMillis;
        }

        public void setClientTimeoutMillis(long l) {
            this.clientTimeoutMillis = l;
        }

        public int getPaginateSize() {
            return this.paginateSize;
        }

        public void setPaginateSize(int n) {
            this.paginateSize = n;
        }

        public boolean getTrackDigests() {
            return this.trackDigests;
        }

        public boolean isTrackDigests() {
            return this.trackDigests;
        }

        public void setTrackDigests(boolean bl) {
            this.trackDigests = bl;
        }

        public boolean getSortTagsByDate() {
            return this.sortTagsByDate;
        }

        public boolean isSortTagsByDate() {
            return this.sortTagsByDate;
        }

        public void setSortTagsByDate(boolean bl) {
            this.sortTagsByDate = bl;
        }

        public boolean getInsecureRegistry() {
            return this.insecureRegistry;
        }

        public boolean isInsecureRegistry() {
            return this.insecureRegistry;
        }

        public void setInsecureRegistry(boolean bl) {
            this.insecureRegistry = bl;
        }

        public List<String> getRepositories() {
            return this.repositories;
        }

        public void setRepositories(List<String> list) {
            this.repositories = list;
        }

        public List<String> getSkip() {
            return this.skip;
        }

        public void setSkip(List<String> list) {
            this.skip = list;
        }

        public String getCatalogFile() {
            return this.catalogFile;
        }

        public void setCatalogFile(String string) {
            this.catalogFile = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "<$constructor$>";
            stringArray[2] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[3];
            Builder.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(Builder.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Builder.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

