/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth;

import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.DockerUserAgent;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerToken;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.exception.DockerRegistryAuthenticationException;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RestAdapter;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.Path;
import retrofit.http.Query;

public class DockerBearerTokenService
implements GroovyObject {
    private Map<String, TokenService> realmToService;
    private Map<String, DockerBearerToken> cachedTokens;
    private String username;
    private String password;
    private String passwordCommand;
    private File passwordFile;
    private String authWarning;
    private static final String userAgent;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DockerBearerTokenService() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(HashMap.class);
        this.realmToService = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        Object object2 = callSiteArray[1].callConstructor(HashMap.class);
        this.cachedTokens = (Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class);
    }

    public DockerBearerTokenService(String username, String password, String passwordCommand) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this();
        String string = username;
        this.username = ShortTypeHandling.castToString((Object)string);
        String string2 = password;
        this.password = ShortTypeHandling.castToString((Object)string2);
        String string3 = passwordCommand;
        this.passwordCommand = ShortTypeHandling.castToString((Object)string3);
    }

    public DockerBearerTokenService(String username, File passwordFile) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this();
        String string = username;
        this.username = ShortTypeHandling.castToString((Object)string);
        File file = passwordFile;
        this.passwordFile = (File)ScriptBytecodeAdapter.castToType((Object)file, File.class);
    }

    public String getBasicAuth() {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        if (!(DefaultTypeTransformation.booleanUnbox((Object)this.username) || DefaultTypeTransformation.booleanUnbox((Object)this.password) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile))) {
            return ShortTypeHandling.castToString(null);
        }
        Object resolvedPassword = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)this.password)) {
            String string = this.password;
            resolvedPassword = string;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand)) {
            Object object;
            Object pb = callSiteArray[2].callConstructor(ProcessBuilder.class, (Object)"bash", (Object)"-c", (Object)this.passwordCommand);
            Object process = callSiteArray[3].call(pb);
            Object errCode = callSiteArray[4].call(process);
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)log)) ? callSiteArray[6].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[7].call(pb)}, new String[]{"Full command is: ", ""})) : null;
            if (ScriptBytecodeAdapter.compareNotEqual((Object)errCode, (Object)0)) {
                Object err = callSiteArray[8].call(IOUtils.class, callSiteArray[9].call(process));
                Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call((Object)log)) ? callSiteArray[11].call((Object)log, (Object)new GStringImpl(new Object[]{err}, new String[]{"Password command returned a non 0 return code, stderr/stdout was: '", "'"})) : null;
            }
            resolvedPassword = object = callSiteArray[12].call(callSiteArray[13].call(IOUtils.class, callSiteArray[14].call(process)));
            Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call((Object)log)) ? callSiteArray[16].call((Object)log, (Object)new GStringImpl(new Object[]{resolvedPassword}, new String[]{"resolvedPassword is ", ""})) : null;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile)) {
            Object object;
            resolvedPassword = object = callSiteArray[17].call(callSiteArray[18].callConstructor(BufferedReader.class, callSiteArray[19].callConstructor(FileReader.class, (Object)this.passwordFile)));
        } else {
            String string = "";
            resolvedPassword = string;
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[20].callSafe(resolvedPassword), (Object)0)) {
            String message = "Your registry password has %s whitespace, if this is unintentional authentication will fail.";
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call(callSiteArray[22].call(resolvedPassword, (Object)0)))) {
                Object object = callSiteArray[23].callCurrent((GroovyObject)this, (Object)message, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"leading"}));
                this.authWarning = ShortTypeHandling.castToString((Object)object);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call(callSiteArray[25].call(resolvedPassword, callSiteArray[26].call(callSiteArray[27].call(resolvedPassword), (Object)1))))) {
                Object object = callSiteArray[28].callCurrent((GroovyObject)this, (Object)message, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"trailing"}));
                this.authWarning = ShortTypeHandling.castToString((Object)object);
            }
        }
        Object basicAuth = callSiteArray[29].callConstructor(String.class, callSiteArray[30].call(callSiteArray[31].callGetProperty(Base64.class), callSiteArray[32].callGroovyObjectGetProperty((Object)new GStringImpl(new Object[]{this.username, resolvedPassword}, new String[]{"", ":", ""}))));
        return ShortTypeHandling.castToString((Object)basicAuth);
    }

    public String getBasicAuthHeader() {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object basicAuth = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            basicAuth = object = callSiteArray[33].callCurrent((GroovyObject)this);
        } else {
            String string = this.getBasicAuth();
            basicAuth = string;
        }
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)basicAuth) ? new GStringImpl(new Object[]{basicAuth}, new String[]{"Basic ", ""}) : null));
    }

    public AuthenticateDetails parseBearerAuthenticateHeader(String header) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        String realmKey = "realm";
        String serviceKey = "service";
        String scopeKey = "scope";
        AuthenticateDetails result = (AuthenticateDetails)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(AuthenticateDetails.class, (Object)this), AuthenticateDetails.class);
        while (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[35].call((Object)header), (Object)0)) {
            String key = null;
            String value = null;
            Object keyEnd = callSiteArray[36].call((Object)header, (Object)"=");
            if (ScriptBytecodeAdapter.compareEqual((Object)keyEnd, (Object)-1)) {
                throw (Throwable)callSiteArray[37].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{header}, new String[]{"Www-Authenticate header terminated with junk: '", "'."}));
            }
            Object object = callSiteArray[38].call((Object)header, (Object)0, keyEnd);
            key = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[39].call((Object)header, callSiteArray[40].call(keyEnd, (Object)1));
            header = ShortTypeHandling.castToString((Object)object2);
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[41].call((Object)header), (Object)0)) {
                throw (Throwable)callSiteArray[42].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{key}, new String[]{"Www-Authenticate header unmatched parameter key: '", "'."}));
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[43].call((Object)header, (Object)0), (Object)"\"")) {
                Object object3 = callSiteArray[44].call((Object)header, (Object)1);
                header = ShortTypeHandling.castToString((Object)object3);
                Object valueEnd = callSiteArray[45].call((Object)header, (Object)"\"");
                if (ScriptBytecodeAdapter.compareEqual((Object)valueEnd, (Object)-1)) {
                    throw (Throwable)callSiteArray[46].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header has unterminated \" (quotation mark).");
                }
                Object object4 = callSiteArray[47].call((Object)header, (Object)0, valueEnd);
                value = ShortTypeHandling.castToString((Object)object4);
                Object object5 = callSiteArray[48].call((Object)header, callSiteArray[49].call(valueEnd, (Object)1));
                header = ShortTypeHandling.castToString((Object)object5);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[50].call((Object)header), (Object)0)) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[51].call((Object)header, (Object)0), (Object)",")) {
                        throw (Throwable)callSiteArray[52].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header params must be separated by , (comma).");
                    }
                    Object object6 = callSiteArray[53].call((Object)header, (Object)1);
                    header = ShortTypeHandling.castToString((Object)object6);
                }
            } else {
                Object valueEnd = callSiteArray[54].call((Object)header, (Object)",");
                if (ScriptBytecodeAdapter.compareEqual((Object)valueEnd, (Object)-1)) {
                    String string;
                    String string2;
                    value = string2 = header;
                    header = string = "";
                } else {
                    Object object7 = callSiteArray[55].call((Object)header, (Object)0, valueEnd);
                    value = ShortTypeHandling.castToString((Object)object7);
                    Object object8 = callSiteArray[56].call((Object)header, callSiteArray[57].call(valueEnd, (Object)1));
                    header = ShortTypeHandling.castToString((Object)object8);
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call((Object)key, (Object)realmKey))) {
                Object url = callSiteArray[59].callConstructor(URL.class, (Object)value);
                Object object9 = callSiteArray[60].call(callSiteArray[61].call(callSiteArray[62].callGetProperty(url), (Object)"://"), callSiteArray[63].callGetProperty(url));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object9, DockerBearerTokenService.class, (GroovyObject)result, (String)"realm");
                Object object10 = callSiteArray[64].callGetProperty(url);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object10, DockerBearerTokenService.class, (GroovyObject)result, (String)"path");
                if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[65].call(callSiteArray[66].callGroovyObjectGetProperty((Object)result)), (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[67].call(callSiteArray[68].callGroovyObjectGetProperty((Object)result), (Object)0), (Object)"/"))) continue;
                Object object11 = callSiteArray[69].call(callSiteArray[70].callGroovyObjectGetProperty((Object)result), (Object)1);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object11, DockerBearerTokenService.class, (GroovyObject)result, (String)"path");
                continue;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call((Object)key, (Object)serviceKey))) {
                String string = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, DockerBearerTokenService.class, (GroovyObject)result, (String)"service");
                continue;
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[72].call((Object)key, (Object)scopeKey))) continue;
            String string = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, DockerBearerTokenService.class, (GroovyObject)result, (String)"scope");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].callGroovyObjectGetProperty((Object)result))) {
            throw (Throwable)callSiteArray[74].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header must provide 'realm' parameter.");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].callGroovyObjectGetProperty((Object)result))) {
            Object var28_28 = null;
            ScriptBytecodeAdapter.setGroovyObjectProperty(var28_28, DockerBearerTokenService.class, (GroovyObject)result, (String)"service");
        }
        return result;
    }

    private Object getTokenService(String realm) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object tokenService = callSiteArray[76].call(this.realmToService, (Object)realm);
        if (ScriptBytecodeAdapter.compareEqual((Object)tokenService, null)) {
            Object object;
            Object builder = callSiteArray[77].call(callSiteArray[78].call(callSiteArray[79].call(callSiteArray[80].callConstructor(RestAdapter.Builder.class), (Object)realm), callSiteArray[81].callGetProperty(RestAdapter.LogLevel.class)));
            tokenService = object = callSiteArray[82].call(builder, TokenService.class);
            Object object2 = tokenService;
            callSiteArray[83].call(this.realmToService, (Object)realm, object2);
        }
        return tokenService;
    }

    public DockerBearerToken getToken(String repository) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return (DockerBearerToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call(this.cachedTokens, (Object)repository), DockerBearerToken.class);
    }

    public DockerBearerToken getToken(String repository, String authenticateHeader) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object authenticateDetails = null;
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object;
                authenticateDetails = object = callSiteArray[85].callCurrent((GroovyObject)this, (Object)authenticateHeader);
            } else {
                AuthenticateDetails authenticateDetails2 = this.parseBearerAuthenticateHeader(authenticateHeader);
                authenticateDetails = authenticateDetails2;
            }
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[86].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[87].callGetProperty((Object)e)}, new String[]{"Failed to parse www-authenticate header: ", ""}));
        }
        Object tokenService = callSiteArray[88].callCurrent((GroovyObject)this, callSiteArray[89].callGetProperty(authenticateDetails));
        Object token = null;
        try {
            Object object;
            Object object2;
            token = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].callGroovyObjectGetProperty((Object)this)) ? (object2 = callSiteArray[91].call(tokenService, ArrayUtil.createArray((Object)callSiteArray[92].callGetProperty(authenticateDetails), (Object)callSiteArray[93].callGetProperty(authenticateDetails), (Object)callSiteArray[94].callGetProperty(authenticateDetails), (Object)callSiteArray[95].callGroovyObjectGetProperty((Object)this), (Object)userAgent))) : (object = callSiteArray[96].call(tokenService, callSiteArray[97].callGetProperty(authenticateDetails), callSiteArray[98].callGetProperty(authenticateDetails), callSiteArray[99].callGetProperty(authenticateDetails), (Object)userAgent));
        }
        catch (Exception e) {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.authWarning)) {
                throw (Throwable)callSiteArray[100].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{this.authWarning, callSiteArray[101].call((Object)e)}, new String[]{"Authentication failed (", "): ", ""}), (Object)e);
            }
            throw (Throwable)callSiteArray[102].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[103].call((Object)e)}, new String[]{"Authentication failed: ", ""}), (Object)e);
        }
        Object object = token;
        callSiteArray[104].call(this.cachedTokens, (Object)repository, object);
        return (DockerBearerToken)ScriptBytecodeAdapter.castToType((Object)token, DockerBearerToken.class);
    }

    public void clearToken(String repository) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        callSiteArray[105].call(this.cachedTokens, (Object)repository);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerBearerTokenService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = DockerBearerTokenService.$getCallSiteArray()[106].call(DockerUserAgent.class);
        userAgent = ShortTypeHandling.castToString((Object)object);
        Object object2 = DockerBearerTokenService.$getCallSiteArray()[107].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerTokenService");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    public Map<String, TokenService> getRealmToService() {
        return this.realmToService;
    }

    public void setRealmToService(Map<String, TokenService> map) {
        this.realmToService = map;
    }

    public Map<String, DockerBearerToken> getCachedTokens() {
        return this.cachedTokens;
    }

    public void setCachedTokens(Map<String, DockerBearerToken> map) {
        this.cachedTokens = map;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPasswordCommand() {
        return this.passwordCommand;
    }

    public void setPasswordCommand(String string) {
        this.passwordCommand = string;
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(File file) {
        this.passwordFile = file;
    }

    public String getAuthWarning() {
        return this.authWarning;
    }

    public void setAuthWarning(String string) {
        this.authWarning = string;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "start";
        stringArray[4] = "waitFor";
        stringArray[5] = "isDebugEnabled";
        stringArray[6] = "debug";
        stringArray[7] = "command";
        stringArray[8] = "toString";
        stringArray[9] = "getErrorStream";
        stringArray[10] = "isErrorEnabled";
        stringArray[11] = "error";
        stringArray[12] = "trim";
        stringArray[13] = "toString";
        stringArray[14] = "getInputStream";
        stringArray[15] = "isDebugEnabled";
        stringArray[16] = "debug";
        stringArray[17] = "getText";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "length";
        stringArray[21] = "isWhitespace";
        stringArray[22] = "charAt";
        stringArray[23] = "sprintf";
        stringArray[24] = "isWhitespace";
        stringArray[25] = "charAt";
        stringArray[26] = "minus";
        stringArray[27] = "length";
        stringArray[28] = "sprintf";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "encode";
        stringArray[31] = "encoder";
        stringArray[32] = "bytes";
        stringArray[33] = "getBasicAuth";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "length";
        stringArray[36] = "indexOf";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "substring";
        stringArray[39] = "substring";
        stringArray[40] = "plus";
        stringArray[41] = "length";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "getAt";
        stringArray[44] = "substring";
        stringArray[45] = "indexOf";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "substring";
        stringArray[48] = "substring";
        stringArray[49] = "plus";
        stringArray[50] = "length";
        stringArray[51] = "getAt";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "substring";
        stringArray[54] = "indexOf";
        stringArray[55] = "substring";
        stringArray[56] = "substring";
        stringArray[57] = "plus";
        stringArray[58] = "equalsIgnoreCase";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "plus";
        stringArray[61] = "plus";
        stringArray[62] = "protocol";
        stringArray[63] = "authority";
        stringArray[64] = "path";
        stringArray[65] = "length";
        stringArray[66] = "path";
        stringArray[67] = "getAt";
        stringArray[68] = "path";
        stringArray[69] = "substring";
        stringArray[70] = "path";
        stringArray[71] = "equalsIgnoreCase";
        stringArray[72] = "equalsIgnoreCase";
        stringArray[73] = "realm";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "service";
        stringArray[76] = "get";
        stringArray[77] = "build";
        stringArray[78] = "setLogLevel";
        stringArray[79] = "setEndpoint";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "NONE";
        stringArray[82] = "create";
        stringArray[83] = "putAt";
        stringArray[84] = "getAt";
        stringArray[85] = "parseBearerAuthenticateHeader";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "message";
        stringArray[88] = "getTokenService";
        stringArray[89] = "realm";
        stringArray[90] = "basicAuthHeader";
        stringArray[91] = "getToken";
        stringArray[92] = "path";
        stringArray[93] = "service";
        stringArray[94] = "scope";
        stringArray[95] = "basicAuthHeader";
        stringArray[96] = "getToken";
        stringArray[97] = "path";
        stringArray[98] = "service";
        stringArray[99] = "scope";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "getMessage";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "getMessage";
        stringArray[104] = "putAt";
        stringArray[105] = "remove";
        stringArray[106] = "getUserAgent";
        stringArray[107] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[108];
        DockerBearerTokenService.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DockerBearerTokenService.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DockerBearerTokenService.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    interface TokenService {
        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public DockerBearerToken getToken(@Path(encode=false, value="path") String var1, @Query(value="service") String var2, @Query(value="scope") String var3, @Header(value="User-Agent") String var4);

        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public DockerBearerToken getToken(@Path(encode=false, value="path") String var1, @Query(value="service") String var2, @Query(value="scope") String var3, @Header(value="Authorization") String var4, @Header(value="User-Agent") String var5);
    }

    class AuthenticateDetails
    implements GroovyObject {
        private String realm;
        private String path;
        private String service;
        private String scope;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        public /* synthetic */ DockerBearerTokenService this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public AuthenticateDetails(DockerBearerTokenService $p$) {
            MetaClass metaClass;
            DockerBearerTokenService dockerBearerTokenService;
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            this.this$0 = dockerBearerTokenService = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AuthenticateDetails.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AuthenticateDetails.class, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AuthenticateDetails.class, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String string) {
            this.realm = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String string) {
            this.service = string;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String string) {
            this.scope = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AuthenticateDetails.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AuthenticateDetails.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

