/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactTypes;
import java.util.regex.Pattern;

public class ArtifactReplacerFactory {
    public static ArtifactReplacer.Replacer dockerImageReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$.spec.template.spec.containers.[?( @.image == \"{%name%}\" )].image").findPath("$.spec.template.spec.containers.*.image").namePattern(Pattern.compile("([0-9A-Za-z./]+).*")).type(ArtifactTypes.DOCKER_IMAGE).build();
    }

    public static ArtifactReplacer.Replacer configMapVolumeReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$.spec.template.spec.volumes.[?( @.configMap.name == \"{%name%}\" )].configMap.name").findPath("$.spec.template.spec.volumes.*.configMap.name").type(ArtifactTypes.KUBERNETES_CONFIG_MAP).build();
    }

    public static ArtifactReplacer.Replacer secretVolumeReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$.spec.template.spec.volumes.[?( @.secret.name == \"{%name%}\" )].secret.name").findPath("$.spec.template.spec.volumes.*.secret.name").type(ArtifactTypes.KUBERNETES_SECRET).build();
    }

    public static ArtifactReplacer.Replacer configMapEnvFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$.spec.template.spec.containers.*.envFrom.[?( @.configMapRef.name == \"{%name%}\" )].configMapRef.name").findPath("$.spec.template.spec.containers.*.envFrom.*.configMapRef.name").type(ArtifactTypes.KUBERNETES_CONFIG_MAP).build();
    }

    public static ArtifactReplacer.Replacer secretEnvFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$.spec.template.spec.containers.*.envFrom.[?( @.secretRef.name == \"{%name%}\" )].secretRef.name").findPath("$.spec.template.spec.containers.*.envFrom.*.secretRef.name").type(ArtifactTypes.KUBERNETES_SECRET).build();
    }
}

