/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2ServerGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.ManifestBasedModel;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2ServerGroupCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.LoadBalancer;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerServerGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesV2LoadBalancer
extends ManifestBasedModel
implements LoadBalancer,
LoadBalancerProvider.Details {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2LoadBalancer.class);
    Set<LoadBalancerServerGroup> serverGroups = new HashSet<LoadBalancerServerGroup>();
    KubernetesManifest manifest;
    Keys.InfrastructureCacheKey key;

    private KubernetesV2LoadBalancer(KubernetesManifest manifest, String key, Set<LoadBalancerServerGroup> serverGroups) {
        this.manifest = manifest;
        this.key = (Keys.InfrastructureCacheKey)Keys.parseKey(key).get();
        this.serverGroups = serverGroups;
    }

    public static KubernetesV2LoadBalancer fromCacheData(CacheData cd, List<CacheData> serverGroupData, Map<String, List<CacheData>> serverGroupToInstanceData) {
        if (cd == null) {
            return null;
        }
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cd);
        if (manifest == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cd.getId());
            return null;
        }
        Set<LoadBalancerServerGroup> serverGroups = serverGroupData.stream().map(d -> KubernetesV2ServerGroup.fromCacheData(KubernetesV2ServerGroupCacheData.builder().serverGroupData((CacheData)d).instanceData((List)serverGroupToInstanceData.get(d.getId())).loadBalancerData(new ArrayList<CacheData>()).build())).filter(Objects::nonNull).map(KubernetesV2ServerGroup::toLoadBalancerServerGroup).collect(Collectors.toSet());
        return new KubernetesV2LoadBalancer(manifest, cd.getId(), serverGroups);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesV2LoadBalancer)) {
            return false;
        }
        KubernetesV2LoadBalancer other = (KubernetesV2LoadBalancer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<LoadBalancerServerGroup> this$serverGroups = this.getServerGroups();
        Set<LoadBalancerServerGroup> other$serverGroups = other.getServerGroups();
        if (this$serverGroups == null ? other$serverGroups != null : !((Object)this$serverGroups).equals(other$serverGroups)) {
            return false;
        }
        KubernetesManifest this$manifest = this.getManifest();
        KubernetesManifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        Keys.InfrastructureCacheKey this$key = this.getKey();
        Keys.InfrastructureCacheKey other$key = other.getKey();
        return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesV2LoadBalancer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Set<LoadBalancerServerGroup> $serverGroups = this.getServerGroups();
        result = result * 59 + ($serverGroups == null ? 43 : ((Object)$serverGroups).hashCode());
        KubernetesManifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        Keys.InfrastructureCacheKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        return result;
    }

    public Set<LoadBalancerServerGroup> getServerGroups() {
        return this.serverGroups;
    }

    @Override
    public KubernetesManifest getManifest() {
        return this.manifest;
    }

    @Override
    public Keys.InfrastructureCacheKey getKey() {
        return this.key;
    }

    public KubernetesV2LoadBalancer setServerGroups(Set<LoadBalancerServerGroup> serverGroups) {
        this.serverGroups = serverGroups;
        return this;
    }

    public KubernetesV2LoadBalancer setManifest(KubernetesManifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public KubernetesV2LoadBalancer setKey(Keys.InfrastructureCacheKey key) {
        this.key = key;
        return this;
    }

    public String toString() {
        return "KubernetesV2LoadBalancer(serverGroups=" + this.getServerGroups() + ", manifest=" + this.getManifest() + ", key=" + this.getKey() + ")";
    }
}

