/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description;

import com.netflix.spinnaker.clouddriver.kubernetes.config.CustomKubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesUnversionedArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesVersionedArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CustomKubernetesHandlerFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import java.beans.ConstructorProperties;

public class KubernetesResourceProperties {
    KubernetesHandler handler;
    boolean versioned;
    KubernetesVersionedArtifactConverter versionedConverter;
    KubernetesUnversionedArtifactConverter unversionedConverter;

    public static KubernetesResourceProperties fromCustomResource(CustomKubernetesResource customResource) {
        KubernetesHandler handler = CustomKubernetesHandlerFactory.create(KubernetesKind.fromString(customResource.getKubernetesKind()), KubernetesSpinnakerKindMap.SpinnakerKind.fromString(customResource.getSpinnakerKind()), customResource.isVersioned());
        return KubernetesResourceProperties.builder().handler(handler).versioned(customResource.isVersioned()).versionedConverter(new KubernetesVersionedArtifactConverter()).unversionedConverter(new KubernetesUnversionedArtifactConverter()).build();
    }

    public static KubernetesResourcePropertiesBuilder builder() {
        return new KubernetesResourcePropertiesBuilder();
    }

    public KubernetesHandler getHandler() {
        return this.handler;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public KubernetesVersionedArtifactConverter getVersionedConverter() {
        return this.versionedConverter;
    }

    public KubernetesUnversionedArtifactConverter getUnversionedConverter() {
        return this.unversionedConverter;
    }

    public KubernetesResourceProperties setHandler(KubernetesHandler handler) {
        this.handler = handler;
        return this;
    }

    public KubernetesResourceProperties setVersioned(boolean versioned) {
        this.versioned = versioned;
        return this;
    }

    public KubernetesResourceProperties setVersionedConverter(KubernetesVersionedArtifactConverter versionedConverter) {
        this.versionedConverter = versionedConverter;
        return this;
    }

    public KubernetesResourceProperties setUnversionedConverter(KubernetesUnversionedArtifactConverter unversionedConverter) {
        this.unversionedConverter = unversionedConverter;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesResourceProperties)) {
            return false;
        }
        KubernetesResourceProperties other = (KubernetesResourceProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KubernetesHandler this$handler = this.getHandler();
        KubernetesHandler other$handler = other.getHandler();
        if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
            return false;
        }
        if (this.isVersioned() != other.isVersioned()) {
            return false;
        }
        KubernetesVersionedArtifactConverter this$versionedConverter = this.getVersionedConverter();
        KubernetesVersionedArtifactConverter other$versionedConverter = other.getVersionedConverter();
        if (this$versionedConverter == null ? other$versionedConverter != null : !this$versionedConverter.equals(other$versionedConverter)) {
            return false;
        }
        KubernetesUnversionedArtifactConverter this$unversionedConverter = this.getUnversionedConverter();
        KubernetesUnversionedArtifactConverter other$unversionedConverter = other.getUnversionedConverter();
        return !(this$unversionedConverter == null ? other$unversionedConverter != null : !this$unversionedConverter.equals(other$unversionedConverter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesResourceProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KubernetesHandler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        result = result * 59 + (this.isVersioned() ? 79 : 97);
        KubernetesVersionedArtifactConverter $versionedConverter = this.getVersionedConverter();
        result = result * 59 + ($versionedConverter == null ? 43 : $versionedConverter.hashCode());
        KubernetesUnversionedArtifactConverter $unversionedConverter = this.getUnversionedConverter();
        result = result * 59 + ($unversionedConverter == null ? 43 : $unversionedConverter.hashCode());
        return result;
    }

    public String toString() {
        return "KubernetesResourceProperties(handler=" + this.getHandler() + ", versioned=" + this.isVersioned() + ", versionedConverter=" + this.getVersionedConverter() + ", unversionedConverter=" + this.getUnversionedConverter() + ")";
    }

    public KubernetesResourceProperties() {
    }

    @ConstructorProperties(value={"handler", "versioned", "versionedConverter", "unversionedConverter"})
    public KubernetesResourceProperties(KubernetesHandler handler, boolean versioned, KubernetesVersionedArtifactConverter versionedConverter, KubernetesUnversionedArtifactConverter unversionedConverter) {
        this.handler = handler;
        this.versioned = versioned;
        this.versionedConverter = versionedConverter;
        this.unversionedConverter = unversionedConverter;
    }

    public static class KubernetesResourcePropertiesBuilder {
        private KubernetesHandler handler;
        private boolean versioned;
        private KubernetesVersionedArtifactConverter versionedConverter;
        private KubernetesUnversionedArtifactConverter unversionedConverter;

        KubernetesResourcePropertiesBuilder() {
        }

        public KubernetesResourcePropertiesBuilder handler(KubernetesHandler handler) {
            this.handler = handler;
            return this;
        }

        public KubernetesResourcePropertiesBuilder versioned(boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        public KubernetesResourcePropertiesBuilder versionedConverter(KubernetesVersionedArtifactConverter versionedConverter) {
            this.versionedConverter = versionedConverter;
            return this;
        }

        public KubernetesResourcePropertiesBuilder unversionedConverter(KubernetesUnversionedArtifactConverter unversionedConverter) {
            this.unversionedConverter = unversionedConverter;
            return this;
        }

        public KubernetesResourceProperties build() {
            return new KubernetesResourceProperties(this.handler, this.versioned, this.versionedConverter, this.unversionedConverter);
        }

        public String toString() {
            return "KubernetesResourceProperties.KubernetesResourcePropertiesBuilder(handler=" + this.handler + ", versioned=" + this.versioned + ", versionedConverter=" + this.versionedConverter + ", unversionedConverter=" + this.unversionedConverter + ")";
        }
    }
}

