/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesDaemonSetCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1beta2DaemonSet;
import io.kubernetes.client.models.V1beta2DaemonSetStatus;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class KubernetesDaemonSetHandler
extends KubernetesHandler
implements CanResize,
CanDelete,
CanPauseRollout,
CanResumeRollout,
CanUndoRollout,
ServerGroupHandler {
    @Override
    public KubernetesKind kind() {
        return KubernetesKind.DAEMON_SET;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesDaemonSetCachingAgent.class;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V1beta2DaemonSet v1beta2DaemonSet = KubernetesCacheDataConverter.getResource(manifest, V1beta2DaemonSet.class);
        return this.status(v1beta2DaemonSet);
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map<String, Object> result = super.hydrateSearchResult(key, cacheUtils);
        result.put("serverGroup", result.get("name"));
        return result;
    }

    private Manifest.Status status(V1beta2DaemonSet daemonSet) {
        Manifest.Status result = new Manifest.Status();
        V1beta2DaemonSetStatus status = daemonSet.getStatus();
        if (status == null) {
            result.unstable("No status reported yet").unavailable("No availability reported");
            return result;
        }
        int desiredReplicas = status.getDesiredNumberScheduled();
        Integer existing = status.getCurrentNumberScheduled();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be scheduled");
        }
        existing = status.getUpdatedNumberScheduled();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all updated replicas to be scheduled");
        }
        existing = status.getNumberAvailable();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be available");
        }
        existing = status.getNumberReady();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be ready");
        }
        return result;
    }
}

