/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacerFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesDeploymentCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.ServerGroupManagerHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.UnsupportedVersionException;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1beta2Deployment;
import io.kubernetes.client.models.V1beta2DeploymentCondition;
import io.kubernetes.client.models.V1beta2DeploymentStatus;
import org.springframework.stereotype.Component;

@Component
public class KubernetesDeploymentHandler
extends KubernetesHandler
implements CanResize,
CanDelete,
CanScale,
CanPauseRollout,
CanResumeRollout,
CanUndoRollout,
ServerGroupManagerHandler {
    public KubernetesDeploymentHandler() {
        this.registerReplacer(ArtifactReplacerFactory.dockerImageReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapEnvFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretEnvFromReplacer());
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.DEPLOYMENT;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUP_MANAGERS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        if (manifest.getApiVersion().equals(KubernetesApiVersion.EXTENSIONS_V1BETA1) || manifest.getApiVersion().equals(KubernetesApiVersion.APPS_V1BETA1) || manifest.getApiVersion().equals(KubernetesApiVersion.APPS_V1BETA2)) {
            V1beta2Deployment appsV1beta2Deployment = KubernetesCacheDataConverter.getResource(manifest, V1beta2Deployment.class);
            return this.status(appsV1beta2Deployment);
        }
        throw new UnsupportedVersionException(manifest);
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesDeploymentCachingAgent.class;
    }

    private Manifest.Status status(V1beta2Deployment deployment) {
        Manifest.Status result = new Manifest.Status();
        V1beta2DeploymentStatus status = deployment.getStatus();
        if (status == null) {
            result.unstable("No status reported yet").unavailable("No availability reported");
            return result;
        }
        V1beta2DeploymentCondition paused = status.getConditions().stream().filter(c -> c.getReason().equalsIgnoreCase("deploymentpaused")).findAny().orElse(null);
        V1beta2DeploymentCondition available = status.getConditions().stream().filter(c -> c.getType().equalsIgnoreCase("available")).findAny().orElse(null);
        if (paused != null) {
            result.paused(paused.getMessage());
        }
        if (available != null && available.getStatus().equalsIgnoreCase("false")) {
            result.unavailable(available.getMessage());
        }
        int desiredReplicas = deployment.getSpec().getReplicas();
        Integer existing = status.getUpdatedReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be updated");
        }
        existing = status.getAvailableReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be available");
        }
        existing = status.getReadyReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be ready");
        }
        return result;
    }
}

