/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDeploy;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubernetesHandler
implements CanDeploy,
CanDelete {
    private static final Logger log = LoggerFactory.getLogger(KubernetesHandler.class);
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    private final ArtifactReplacer artifactReplacer = new ArtifactReplacer();

    @Override
    public abstract KubernetesKind kind();

    public abstract boolean versioned();

    public abstract KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind();

    public abstract Manifest.Status status(KubernetesManifest var1);

    protected void registerReplacer(ArtifactReplacer.Replacer replacer) {
        this.artifactReplacer.addReplacer(replacer);
    }

    public ArtifactReplacer.ReplaceResult replaceArtifacts(KubernetesManifest manifest, List<Artifact> artifacts) {
        return this.artifactReplacer.replaceAll(manifest, artifacts);
    }

    protected Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return null;
    }

    public Set<Artifact> listArtifacts(KubernetesManifest manifest) {
        return this.artifactReplacer.findAll(manifest);
    }

    public KubernetesV2CachingAgent buildCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        Constructor<? extends KubernetesV2CachingAgent> constructor;
        Class<? extends KubernetesV2CachingAgent> clazz = this.cachingAgentClass();
        if (clazz == null) {
            log.error("No caching agent was registered for {} -- no resources will be cached", (Object)this.kind());
        }
        try {
            constructor = clazz.getDeclaredConstructor(KubernetesNamedAccountCredentials.class, ObjectMapper.class, Registry.class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            log.warn("Missing canonical constructor for {} caching agent", (Object)this.kind(), (Object)e);
            return null;
        }
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.warn("Can't invoke caching agent constructor for {} caching agent", (Object)this.kind(), (Object)e);
            return null;
        }
    }

    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map result = (Map)objectMapper.convertValue((Object)key, (TypeReference)new TypeReference<Map<String, Object>>(){});
        result.put("region", key.getNamespace());
        result.put("name", KubernetesManifest.getFullResourceName(key.getKubernetesKind(), key.getName()));
        return result;
    }
}

