/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactTypes;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesPodCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class KubernetesPodHandler
extends KubernetesHandler
implements CanDelete {
    public KubernetesPodHandler() {
        this.registerReplacer(ArtifactReplacer.Replacer.builder().replacePath("$.spec.containers.[?( @.image == \"{%name%}\" )].image").findPath("$.spec.containers.*.image").type(ArtifactTypes.DOCKER_IMAGE).build());
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.POD;
    }

    @Override
    public boolean versioned() {
        return true;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.INSTANCES;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        return new Manifest.Status();
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map<String, Object> result = super.hydrateSearchResult(key, cacheUtils);
        result.put("instanceId", result.get("name"));
        return result;
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesPodCachingAgent.class;
    }
}

