/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacerFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesReplicaSetCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.UnsupportedVersionException;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1beta1ReplicaSet;
import io.kubernetes.client.models.V1beta2ReplicaSet;
import io.kubernetes.client.models.V1beta2ReplicaSetStatus;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class KubernetesReplicaSetHandler
extends KubernetesHandler
implements CanResize,
CanDelete,
CanScale,
ServerGroupHandler {
    public KubernetesReplicaSetHandler() {
        this.registerReplacer(ArtifactReplacerFactory.dockerImageReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapEnvFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretEnvFromReplacer());
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.REPLICA_SET;
    }

    @Override
    public boolean versioned() {
        return true;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesReplicaSetCachingAgent.class;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        if (manifest.getApiVersion().equals(KubernetesApiVersion.EXTENSIONS_V1BETA1) || manifest.getApiVersion().equals(KubernetesApiVersion.APPS_V1BETA2)) {
            V1beta2ReplicaSet v1beta2ReplicaSet = KubernetesCacheDataConverter.getResource(manifest, V1beta2ReplicaSet.class);
            return this.status(v1beta2ReplicaSet);
        }
        throw new UnsupportedVersionException(manifest);
    }

    private Manifest.Status status(V1beta2ReplicaSet replicaSet) {
        Manifest.Status result = new Manifest.Status();
        int desiredReplicas = replicaSet.getSpec().getReplicas();
        V1beta2ReplicaSetStatus status = replicaSet.getStatus();
        if (status == null) {
            result.unstable("No status reported yet").unavailable("No availability reported");
            return result;
        }
        Integer existing = status.getFullyLabeledReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be fully-labeled").unavailable("Not all replicas have become labeled yet");
        }
        existing = status.getAvailableReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be available").unavailable("Not all replicas have become available yet");
        }
        existing = status.getReadyReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all replicas to be ready");
        }
        return result;
    }

    public static Map<String, String> getPodTemplateLabels(KubernetesManifest manifest) {
        if (manifest.getApiVersion().equals(KubernetesApiVersion.EXTENSIONS_V1BETA1)) {
            V1beta1ReplicaSet v1beta1ReplicaSet = KubernetesCacheDataConverter.getResource(manifest, V1beta1ReplicaSet.class);
            return KubernetesReplicaSetHandler.getPodTemplateLabels(v1beta1ReplicaSet);
        }
        if (manifest.getApiVersion().equals(KubernetesApiVersion.APPS_V1BETA2)) {
            V1beta2ReplicaSet v1beta2ReplicaSet = KubernetesCacheDataConverter.getResource(manifest, V1beta2ReplicaSet.class);
            return KubernetesReplicaSetHandler.getPodTemplateLabels(v1beta2ReplicaSet);
        }
        throw new UnsupportedVersionException(manifest);
    }

    private static Map<String, String> getPodTemplateLabels(V1beta1ReplicaSet replicaSet) {
        return replicaSet.getSpec().getTemplate().getMetadata().getLabels();
    }

    private static Map<String, String> getPodTemplateLabels(V1beta2ReplicaSet replicaSet) {
        return replicaSet.getSpec().getTemplate().getMetadata().getLabels();
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map<String, Object> result = super.hydrateSearchResult(key, cacheUtils);
        result.put("serverGroup", result.get("name"));
        return result;
    }
}

