/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.validator;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Errors;

public class KubernetesValidationUtil {
    private static final Logger log = LoggerFactory.getLogger(KubernetesValidationUtil.class);
    private final String context;
    private final Errors errors;

    public KubernetesValidationUtil(String context, Errors errors) {
        this.context = context;
        this.errors = errors;
    }

    private String joinAttributeChain(String ... attributes) {
        ArrayList<String> chain = new ArrayList<String>();
        chain.add(this.context);
        Collections.addAll(chain, attributes);
        return String.join((CharSequence)".", chain);
    }

    public void reject(String errorName, String ... attributes) {
        String field = this.joinAttributeChain(attributes);
        String error = this.joinAttributeChain(field, errorName);
        this.errors.reject(field, error);
    }

    public boolean validateNotEmpty(String attribute, Object value) {
        if (value == null) {
            this.reject("empty", attribute);
            return false;
        }
        return true;
    }

    public boolean validateSizeEquals(String attribute, Collection items, int size) {
        if (items.size() != size) {
            this.reject("size!=" + size, attribute);
            return false;
        }
        return true;
    }

    public boolean validateNotEmpty(String attribute, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.reject("empty", attribute);
            return false;
        }
        return true;
    }

    public boolean validateV2Credentials(AccountCredentialsProvider provider, String accountName, String namespace) {
        log.info("Validating credentials for {} {}", (Object)accountName, (Object)namespace);
        if (!this.validateNotEmpty("account", accountName)) {
            return false;
        }
        if (!this.validateNotEmpty("namespace", namespace)) {
            return false;
        }
        AccountCredentials credentials = provider.getCredentials(accountName);
        if (credentials == null) {
            this.reject("notFound", "account");
            return false;
        }
        if (!(credentials.getCredentials() instanceof KubernetesV2Credentials)) {
            this.reject("wrongVersion", "account");
            return false;
        }
        return this.validateNamespace(namespace, (KubernetesV2Credentials)credentials.getCredentials());
    }

    protected boolean validateNamespace(String namespace, KubernetesV2Credentials credentials) {
        List<String> configuredNamespaces = credentials.getNamespaces();
        if (configuredNamespaces != null && !configuredNamespaces.isEmpty() && !configuredNamespaces.contains(namespace)) {
            this.reject("wrongNamespace", namespace);
            return false;
        }
        List<String> omitNamespaces = credentials.getOmitNamespaces();
        if (omitNamespaces != null && omitNamespaces.contains(namespace)) {
            this.reject("omittedNamespace", namespace);
            return false;
        }
        return true;
    }
}

