/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPersistentVolumeCachingAgent
extends KubernetesV2CachingAgent {
    private static final Logger log = LoggerFactory.getLogger(KubernetesPersistentVolumeCachingAgent.class);
    private final Collection<AgentDataType> providedDataTypes = Collections.unmodifiableSet(new HashSet<AgentDataType>(Arrays.asList(AgentDataType.Authority.INFORMATIVE.forType(Keys.LogicalKind.APPLICATIONS.toString()), AgentDataType.Authority.INFORMATIVE.forType(Keys.LogicalKind.CLUSTERS.toString()), AgentDataType.Authority.AUTHORITATIVE.forType(KubernetesKind.PERSISTENT_VOLUME.toString()))));

    KubernetesPersistentVolumeCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount);
    }

    @Override
    protected KubernetesKind primaryKind() {
        return KubernetesKind.PERSISTENT_VOLUME;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.providedDataTypes;
    }
}

