/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2OnDemandCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesStatefulSetHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesStatefulSetCachingAgent
extends KubernetesV2OnDemandCachingAgent {
    private static final Logger log = LoggerFactory.getLogger(KubernetesStatefulSetCachingAgent.class);
    private final Collection<AgentDataType> providedDataTypes = Collections.unmodifiableSet(new HashSet<AgentDataType>(Arrays.asList(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.LogicalKind.APPLICATIONS.toString()), AgentDataType.Authority.INFORMATIVE.forType(Keys.LogicalKind.CLUSTERS.toString()), AgentDataType.Authority.INFORMATIVE.forType(KubernetesKind.SERVICE.toString()), AgentDataType.Authority.AUTHORITATIVE.forType(KubernetesKind.STATEFUL_SET.toString()))));

    KubernetesStatefulSetCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount);
    }

    @Override
    protected KubernetesKind primaryKind() {
        return KubernetesKind.STATEFUL_SET;
    }

    @Override
    protected Map<KubernetesManifest, List<KubernetesManifest>> loadSecondaryResourceRelationships(List<KubernetesManifest> primaryResourceList) {
        BiFunction<String, String, String> manifestName = (namespace, name) -> namespace + ":" + name;
        Map<String, KubernetesManifest> services = this.namespaces.stream().map(n -> ((KubernetesV2Credentials)this.credentials).list(KubernetesKind.SERVICE, (String)n)).flatMap(Collection::stream).collect(Collectors.toMap(m -> (String)manifestName.apply(m.getNamespace(), m.getName()), m -> m));
        HashMap<KubernetesManifest, List<KubernetesManifest>> result = new HashMap<KubernetesManifest, List<KubernetesManifest>>();
        for (KubernetesManifest manifest : primaryResourceList) {
            String key;
            String serviceName = KubernetesStatefulSetHandler.serviceName(manifest);
            if (StringUtils.isEmpty((CharSequence)serviceName) || !services.containsKey(key = manifestName.apply(manifest.getNamespace(), serviceName))) continue;
            KubernetesManifest service = services.get(key);
            result.put(manifest, Collections.singletonList(service));
        }
        return result;
    }

    @Override
    protected boolean hasClusterRelationship() {
        return true;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.providedDataTypes;
    }
}

