/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubernetesV2CachingAgent
extends KubernetesCachingAgent<KubernetesV2Credentials> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2CachingAgent.class);
    protected KubectlJobExecutor jobExecutor;
    protected String providerName = KubernetesCloudProvider.getID();

    protected KubernetesV2CachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount);
    }

    protected abstract KubernetesKind primaryKind();

    protected boolean hasClusterRelationship() {
        return false;
    }

    protected List<KubernetesManifest> loadPrimaryResourceList() {
        return this.namespaces.stream().map(n -> ((KubernetesV2Credentials)this.credentials).list(this.primaryKind(), (String)n)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected KubernetesManifest loadPrimaryResource(String namespace, String name) {
        return ((KubernetesV2Credentials)this.credentials).get(this.primaryKind(), namespace, name);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        log.info(this.getAgentType() + " is starting");
        this.reloadNamespaces();
        try {
            return this.buildCacheResult(this.loadPrimaryResourceList());
        }
        catch (KubectlJobExecutor.NoResourceTypeException e) {
            log.warn(this.getAgentType() + ": resource for this caching agent is not supported for this cluster");
            return new DefaultCacheResult(new HashMap());
        }
    }

    protected CacheResult buildCacheResult(KubernetesManifest resource) {
        return this.buildCacheResult(Collections.singletonList(resource));
    }

    protected CacheResult buildCacheResult(List<KubernetesManifest> resources) {
        Map<KubernetesManifest, List<KubernetesManifest>> relationships = this.loadSecondaryResourceRelationships(resources);
        List<CacheData> resourceData = resources.stream().map(rs -> KubernetesCacheDataConverter.convertAsResource(this.accountName, rs, (List)relationships.get(rs), this.hasClusterRelationship())).filter(Objects::nonNull).collect(Collectors.toList());
        List invertedRelationships = resourceData.stream().map(KubernetesCacheDataConverter::invertRelationships).flatMap(Collection::stream).collect(Collectors.toList());
        resourceData.addAll(resources.stream().map(rs -> KubernetesCacheDataConverter.convertAsArtifact(this.accountName, rs)).filter(Objects::nonNull).collect(Collectors.toList()));
        resourceData.addAll(invertedRelationships);
        Map<String, Collection<CacheData>> entries = KubernetesCacheDataConverter.stratifyCacheDataByGroup(KubernetesCacheDataConverter.dedupCacheData(resourceData));
        KubernetesCacheDataConverter.logStratifiedCacheData(this.getAgentType(), entries);
        return new DefaultCacheResult(entries);
    }

    protected Map<KubernetesManifest, List<KubernetesManifest>> loadSecondaryResourceRelationships(List<KubernetesManifest> primaryResourceList) {
        return new HashMap<KubernetesManifest, List<KubernetesManifest>>();
    }

    public String getProviderName() {
        return this.providerName;
    }
}

