/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model;

import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.moniker.Moniker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManifestBasedModel {
    private static final Logger log = LoggerFactory.getLogger(ManifestBasedModel.class);

    public String getName() {
        return this.getManifest().getFullResourceName();
    }

    public String getZone() {
        return this.getManifest().getNamespace();
    }

    public String getRegion() {
        return this.getManifest().getNamespace();
    }

    public String getType() {
        return KubernetesCloudProvider.getID();
    }

    public String getCloudProvider() {
        return KubernetesCloudProvider.getID();
    }

    public String getProviderType() {
        return KubernetesCloudProvider.getID();
    }

    public Moniker getMoniker() {
        return NamerRegistry.lookup().withProvider(KubernetesCloudProvider.getID()).withAccount(this.getAccountName()).withResource(KubernetesManifest.class).deriveMoniker((Object)this.getManifest());
    }

    public String getAccountName() {
        return this.getKey().getAccount();
    }

    public String getAccount() {
        return this.getAccountName();
    }

    public Long getCreatedTime() {
        Map metadata = this.getManifest().getOrDefault("metadata", new HashMap());
        String timestamp = (String)metadata.get("creationTimestamp");
        try {
            if (StringUtils.isNotEmpty((String)timestamp)) {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX").parse(timestamp).getTime();
            }
        }
        catch (ParseException e) {
            log.warn("Failed to parse timestamp: ", (Throwable)e);
        }
        return null;
    }

    public KubernetesKind getKind() {
        return this.getManifest().getKind();
    }

    protected abstract KubernetesManifest getManifest();

    protected abstract Keys.InfrastructureCacheKey getKey();
}

