/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesDeleteManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Collections;
import java.util.List;

public class KubernetesDeleteManifestOperation
implements AtomicOperation<OperationResult> {
    private final KubernetesDeleteManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final KubernetesResourcePropertyRegistry registry;
    private final String accountName;
    private static final String OP_NAME = "DELETE_KUBERNETES_MANIFEST";

    public KubernetesDeleteManifestOperation(KubernetesDeleteManifestDescription description, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.accountName = description.getCredentials().getName();
        this.registry = registry;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List priorOutputs) {
        KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Starting delete operation...");
        List<KubernetesCoordinates> coordinates = this.description.isDynamic() ? this.description.getAllCoordinates() : Collections.singletonList(this.description.getPointCoordinates());
        OperationResult result = new OperationResult();
        coordinates.forEach(c -> {
            KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties for " + c.getKind() + "...");
            KubernetesResourceProperties properties = this.registry.get(this.accountName, c.getKind());
            KubernetesHandler deployer = properties.getHandler();
            if (!(deployer instanceof CanDelete)) {
                throw new IllegalArgumentException("Resource with " + c + " does not support delete");
            }
            KubernetesHandler canDelete = deployer;
            KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Calling delete operation...");
            result.merge(canDelete.delete(this.credentials, c.getNamespace(), c.getName(), this.description.getLabelSelectors(), this.description.getOptions()));
        });
        return result;
    }
}

