/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.ops.servergroup;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesApiConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesClientApiConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.KubernetesServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.KubernetesUtil;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.autoscaler.KubernetesAutoscalerDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.servergroup.DeployKubernetesAtomicOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesClientOperationException;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesOperationException;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.security.KubernetesV1Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.apps.DoneableDeployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.kubernetes.client.models.V1Pod;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class DeployKubernetesAtomicOperation
implements AtomicOperation<DeploymentResult>,
GroovyObject {
    private static final String BASE_PHASE = "DEPLOY";
    private final DeployKubernetesAtomicOperationDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DeployKubernetesAtomicOperation(DeployKubernetesAtomicOperationDescription description) {
        MetaClass metaClass;
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        DeployKubernetesAtomicOperationDescription deployKubernetesAtomicOperationDescription = description;
        this.description = (DeployKubernetesAtomicOperationDescription)ScriptBytecodeAdapter.castToType((Object)deployKubernetesAtomicOperationDescription, DeployKubernetesAtomicOperationDescription.class);
    }

    private static Task getTask() {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public DeploymentResult operate(List priorOutputs) {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        HasMetadata serverGroup = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[2].callCurrent((GroovyObject)this);
            serverGroup = (HasMetadata)ScriptBytecodeAdapter.castToType((Object)object, HasMetadata.class);
        } else {
            HasMetadata hasMetadata;
            serverGroup = hasMetadata = this.deployDescription();
        }
        DeploymentResult deploymentResult = (DeploymentResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(DeploymentResult.class), DeploymentResult.class);
        Object object = callSiteArray[4].call(Arrays.class, callSiteArray[5].call((Object)new GStringImpl(new Object[]{callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty((Object)serverGroup)), callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty((Object)serverGroup))}, new String[]{"", ":", ""})));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DeployKubernetesAtomicOperation.class, (GroovyObject)deploymentResult, (String)"serverGroupNames");
        Object object2 = callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty((Object)serverGroup));
        callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)deploymentResult), callSiteArray[14].callGetProperty(callSiteArray[15].callGetProperty((Object)serverGroup)), object2);
        return deploymentResult;
    }

    public HasMetadata deployDescription() {
        Object object;
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Initializing creation of replica set.");
        callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Looking up provided namespace...");
        Object credentials = callSiteArray[20].callGetProperty(callSiteArray[21].callGroovyObjectGetProperty((Object)this.description));
        Object namespaceToValidate = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callGetPropertySafe(callSiteArray[23].callGroovyObjectGetProperty((Object)this.description)))) {
            Object object2;
            namespaceToValidate = object2 = callSiteArray[24].callGetProperty(callSiteArray[25].callGroovyObjectGetProperty((Object)this.description));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].callGroovyObjectGetProperty((Object)this.description))) {
            Object object3;
            namespaceToValidate = object3 = callSiteArray[27].callGroovyObjectGetProperty((Object)this.description);
        } else {
            String string = "default";
            namespaceToValidate = string;
        }
        Object namespace = callSiteArray[28].call(KubernetesUtil.class, credentials, namespaceToValidate);
        Object object4 = callSiteArray[29].call(callSiteArray[30].callGetProperty(credentials), namespace);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, DeployKubernetesAtomicOperation.class, (GroovyObject)this.description, (String)"imagePullSecrets");
        Object serverGroupNameResolver = callSiteArray[31].callConstructor(KubernetesServerGroupNameResolver.class, namespace, credentials);
        Object clusterName = callSiteArray[32].call(serverGroupNameResolver, callSiteArray[33].callGroovyObjectGetProperty((Object)this.description), callSiteArray[34].callGroovyObjectGetProperty((Object)this.description), callSiteArray[35].callGroovyObjectGetProperty((Object)this.description));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].callGroovyObjectGetProperty((Object)this.description))) {
            return (HasMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callCurrent((GroovyObject)this, credentials, serverGroupNameResolver, clusterName, namespace), HasMetadata.class);
        }
        callSiteArray[38].call(callSiteArray[39].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{clusterName}, new String[]{"Looking up next sequence index for cluster ", "..."}));
        String replicaSetName = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].callGroovyObjectGetProperty((Object)this.description))) {
            Object object5 = callSiteArray[41].call(serverGroupNameResolver, ArrayUtil.createArray((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[43].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[44].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[45].callGroovyObjectGetProperty((Object)this.description), (Object)false));
            replicaSetName = ShortTypeHandling.castToString((Object)object5);
        } else {
            Object object6 = callSiteArray[46].call(serverGroupNameResolver, callSiteArray[47].callGroovyObjectGetProperty((Object)this.description), callSiteArray[48].callGroovyObjectGetProperty((Object)this.description), callSiteArray[49].callGroovyObjectGetProperty((Object)this.description), (Object)false);
            replicaSetName = ShortTypeHandling.castToString((Object)object6);
        }
        callSiteArray[50].call(callSiteArray[51].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{replicaSetName}, new String[]{"Replica set name chosen to be ", "."}));
        Object hasDeployment = callSiteArray[52].call(KubernetesApiConverter.class, (Object)this.description);
        Object replicaSet = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[53].callGetPropertySafe(callSiteArray[54].callGroovyObjectGetProperty((Object)this.description)))) {
            Object object7;
            callSiteArray[55].call(callSiteArray[56].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[57].callGetProperty(callSiteArray[58].callGroovyObjectGetProperty((Object)this.description))}, new String[]{"Searching for ancestor server group ", "..."}));
            Object ancestorServerGroup = callSiteArray[59].call(callSiteArray[60].callGetProperty(credentials), namespace, callSiteArray[61].callGetProperty(callSiteArray[62].callGroovyObjectGetProperty((Object)this.description)));
            if (!DefaultTypeTransformation.booleanUnbox((Object)ancestorServerGroup)) {
                Object object8;
                ancestorServerGroup = object8 = callSiteArray[63].call(callSiteArray[64].callGetProperty(credentials), namespace, callSiteArray[65].callGetProperty(callSiteArray[66].callGroovyObjectGetProperty((Object)this.description)));
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)ancestorServerGroup)) {
                throw (Throwable)callSiteArray[67].callConstructor(KubernetesResourceNotFoundException.class, (Object)new GStringImpl(new Object[]{callSiteArray[68].callGetProperty(callSiteArray[69].callGroovyObjectGetProperty((Object)this.description)), namespace}, new String[]{"Source Server Group: ", " does not exist in Namespace: ", "!"}));
            }
            callSiteArray[70].call(callSiteArray[71].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{ancestorServerGroup}, new String[]{"Ancestor Server Group Located: ", ""}));
            Object object9 = callSiteArray[72].callGetPropertySafe(callSiteArray[73].callGetProperty(ancestorServerGroup));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object9, DeployKubernetesAtomicOperation.class, (GroovyObject)this.description, (String)"targetSize");
            callSiteArray[74].call(callSiteArray[75].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building replica set...");
            replicaSet = object7 = callSiteArray[76].call(KubernetesApiConverter.class, callSiteArray[77].callConstructor(ReplicaSetBuilder.class), (Object)this.description, (Object)replicaSetName);
            if (DefaultTypeTransformation.booleanUnbox((Object)hasDeployment)) {
                int n = 0;
                ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)callSiteArray[78].callGetProperty(replicaSet), (String)"replicas");
            }
        } else {
            Object object10;
            callSiteArray[79].call(callSiteArray[80].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building replica set...");
            replicaSet = object10 = callSiteArray[81].call(KubernetesApiConverter.class, callSiteArray[82].callConstructor(ReplicaSetBuilder.class), (Object)this.description, (Object)replicaSetName);
            if (DefaultTypeTransformation.booleanUnbox((Object)hasDeployment)) {
                int n = 0;
                ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)callSiteArray[83].callGetProperty(replicaSet), (String)"replicas");
            }
        }
        replicaSet = object = callSiteArray[84].call(callSiteArray[85].callGetProperty(credentials), namespace, replicaSet);
        callSiteArray[86].call(callSiteArray[87].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[88].callGetProperty(callSiteArray[89].callGetProperty(replicaSet))}, new String[]{"Deployed replica set ", ""}));
        if (DefaultTypeTransformation.booleanUnbox((Object)hasDeployment)) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].call(callSiteArray[91].callGetProperty(credentials), namespace, clusterName))) {
                callSiteArray[92].call(callSiteArray[93].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building deployment...");
                callSiteArray[94].call(callSiteArray[95].callGetProperty(credentials), namespace, callSiteArray[96].call((Object)((DeploymentBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].call(KubernetesApiConverter.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((DeploymentFluentImpl)callSiteArray[98].callConstructor(DeploymentBuilder.class)), DeploymentFluentImpl.class), (Object)this.description, (Object)replicaSetName), DeploymentBuilder.class))));
            } else {
                callSiteArray[99].call(callSiteArray[100].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Updating deployment...");
                callSiteArray[101].call((Object)((DoneableDeployment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].call(KubernetesApiConverter.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((DeploymentFluentImpl)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].call(callSiteArray[104].callGetProperty(credentials), namespace, clusterName), DeploymentFluentImpl.class)), DeploymentFluentImpl.class), (Object)this.description, (Object)replicaSetName), DoneableDeployment.class)));
            }
            callSiteArray[105].call(callSiteArray[106].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{clusterName}, new String[]{"Configured deployment ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].callGroovyObjectGetProperty((Object)this.description))) {
            callSiteArray[108].call(callSiteArray[109].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Attaching a horizontal pod autoscaler...");
            Object name = DefaultTypeTransformation.booleanUnbox((Object)hasDeployment) ? clusterName : replicaSetName;
            Object kind = DefaultTypeTransformation.booleanUnbox((Object)hasDeployment) ? callSiteArray[110].callGetProperty(KubernetesUtil.class) : callSiteArray[111].callGetProperty(KubernetesUtil.class);
            Object version = DefaultTypeTransformation.booleanUnbox((Object)hasDeployment) ? callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].callGetProperty(credentials), namespace, clusterName)) : callSiteArray[115].call(replicaSet);
            Object autoscaler = callSiteArray[116].call((Object)((HorizontalPodAutoscalerBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].call(KubernetesApiConverter.class, ArrayUtil.createArray((Object)callSiteArray[118].callConstructor(HorizontalPodAutoscalerBuilder.class), (Object)callSiteArray[119].callConstructor(KubernetesAutoscalerDescription.class, (Object)replicaSetName, (Object)this.description), (Object)name, (Object)kind, (Object)version)), HorizontalPodAutoscalerBuilder.class)));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[120].call(callSiteArray[121].callGetProperty(credentials), namespace, name))) {
                callSiteArray[122].call(callSiteArray[123].callGetProperty(credentials), namespace, name);
            }
            callSiteArray[124].call(callSiteArray[125].callGetProperty(credentials), namespace, autoscaler);
        }
        return (HasMetadata)ScriptBytecodeAdapter.castToType((Object)replicaSet, HasMetadata.class);
    }

    public HasMetadata deployController(KubernetesV1Credentials credentials, Object serverGroupNameResolver, String clusterName, String namespace) {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        Object controllerSet = null;
        Object isUpdateControllerEnabled = callSiteArray[126].call(KubernetesClientApiConverter.class, (Object)this.description);
        Object controllerName = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[127].call(KubernetesClientApiConverter.class, (Object)this.description))) {
            Object object;
            controllerName = object = callSiteArray[128].call(serverGroupNameResolver, ArrayUtil.createArray((Object)callSiteArray[129].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[130].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[131].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[132].call(callSiteArray[133].callGroovyObjectGetProperty((Object)this.description)), (Object)false));
        } else {
            String string = clusterName;
            controllerName = string;
        }
        Object object = callSiteArray[134].callGroovyObjectGetProperty((Object)this.description);
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[135].callGetProperty(KubernetesUtil.class))) {
            Object object2;
            controllerSet = object2 = callSiteArray[136].callCurrent((GroovyObject)this, (Object)credentials, controllerName, (Object)namespace, isUpdateControllerEnabled);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[137].callGetProperty(KubernetesUtil.class))) {
            Object object3;
            controllerSet = object3 = callSiteArray[138].callCurrent((GroovyObject)this, (Object)credentials, controllerName, (Object)namespace, isUpdateControllerEnabled);
        } else {
            throw (Throwable)callSiteArray[139].callConstructor(KubernetesOperationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[140].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Controller type ", " is not support."}));
        }
        return (HasMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].call(KubernetesClientApiConverter.class, controllerSet), HasMetadata.class);
    }

    public Object deployStatefulSet(KubernetesV1Credentials credentials, String controllerName, String namespace, Boolean isUpdateControllerEnabled) {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        callSiteArray[142].call(callSiteArray[143].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building stateful set...");
        Object controllerSet = callSiteArray[144].call(KubernetesClientApiConverter.class, (Object)this.description, (Object)controllerName);
        if (DefaultTypeTransformation.booleanUnbox((Object)isUpdateControllerEnabled)) {
            Object deployedControllerSet = callSiteArray[145].call(callSiteArray[146].callGetProperty((Object)credentials), (Object)controllerName, (Object)namespace);
            if (DefaultTypeTransformation.booleanUnbox((Object)deployedControllerSet)) {
                Object object;
                callSiteArray[147].call(callSiteArray[148].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Update stateful set ", ""}));
                controllerSet = object = callSiteArray[149].call(callSiteArray[150].callGetProperty((Object)credentials), (Object)controllerName, (Object)namespace, controllerSet);
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[151].call(callSiteArray[152].callGetPropertySafe(callSiteArray[153].callGetPropertySafe(callSiteArray[154].callGroovyObjectGetProperty((Object)this.description)))), (Object)"Recreate")) {
                    callSiteArray[155].callCurrent((GroovyObject)this, (Object)credentials, (Object)namespace, controllerSet);
                }
            } else {
                Object object;
                callSiteArray[156].call(callSiteArray[157].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Deployed stateful set ", ""}));
                controllerSet = object = callSiteArray[158].call(callSiteArray[159].callGetProperty((Object)credentials), (Object)namespace, controllerSet);
            }
        } else {
            Object object;
            callSiteArray[160].call(callSiteArray[161].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Deployed stateful set ", ""}));
            controllerSet = object = callSiteArray[162].call(callSiteArray[163].callGetProperty((Object)credentials), (Object)namespace, controllerSet);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[164].callGroovyObjectGetProperty((Object)this.description))) {
            callSiteArray[165].call(callSiteArray[166].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Attaching a horizontal pod autoscaler...");
            Object autoscaler = callSiteArray[167].call(KubernetesClientApiConverter.class, callSiteArray[168].callConstructor(KubernetesAutoscalerDescription.class, (Object)controllerName, (Object)this.description), (Object)controllerName, callSiteArray[169].callGroovyObjectGetProperty((Object)this.description));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[170].call(callSiteArray[171].callGetProperty((Object)credentials), (Object)namespace, (Object)controllerName))) {
                callSiteArray[172].call(callSiteArray[173].callGetProperty((Object)credentials), ArrayUtil.createArray((Object)namespace, (Object)controllerName, null, null, null, (Object)true));
            }
            callSiteArray[174].call(callSiteArray[175].callGetProperty((Object)credentials), (Object)namespace, autoscaler);
        }
        return controllerSet;
    }

    public Object deployDaemonSet(KubernetesV1Credentials credentials, String controllerName, String namespace, Boolean isUpdateControllerEnabled) {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        callSiteArray[176].call(callSiteArray[177].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building daemon set...");
        Object controllerSet = callSiteArray[178].call(KubernetesClientApiConverter.class, (Object)this.description, (Object)controllerName);
        if (DefaultTypeTransformation.booleanUnbox((Object)isUpdateControllerEnabled)) {
            Object deployedControllerSet = callSiteArray[179].call(callSiteArray[180].callGetProperty((Object)credentials), (Object)controllerName, (Object)namespace);
            if (DefaultTypeTransformation.booleanUnbox((Object)deployedControllerSet)) {
                Object object;
                callSiteArray[181].call(callSiteArray[182].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Update daemon set ", ""}));
                controllerSet = object = callSiteArray[183].call(callSiteArray[184].callGetProperty((Object)credentials), (Object)controllerName, (Object)namespace, controllerSet);
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[185].call(callSiteArray[186].callGetPropertySafe(callSiteArray[187].callGetPropertySafe(callSiteArray[188].callGroovyObjectGetProperty((Object)this.description)))), (Object)"Recreate")) {
                    callSiteArray[189].callCurrent((GroovyObject)this, (Object)credentials, (Object)namespace, controllerSet);
                }
            } else {
                Object object;
                callSiteArray[190].call(callSiteArray[191].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Deployed daemon set ", ""}));
                controllerSet = object = callSiteArray[192].call(callSiteArray[193].callGetProperty((Object)credentials), (Object)namespace, controllerSet);
            }
        } else {
            Object object;
            callSiteArray[194].call(callSiteArray[195].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Deployed daemon set ", ""}));
            controllerSet = object = callSiteArray[196].call(callSiteArray[197].callGetProperty((Object)credentials), (Object)namespace, controllerSet);
        }
        return controllerSet;
    }

    /*
     * WARNING - void declaration
     */
    public void deletePods(KubernetesV1Credentials credentials, String namespace, Object controllerSet) {
        void var3_3;
        void var2_2;
        Reference credentials2 = new Reference((Object)credentials);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference controllerSet2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        Reference podNameList = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[198].callConstructor(LinkedHashMap.class), Map.class)));
        public class _deletePods_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference podNameList;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deletePods_closure1(Object _outerInstance, Object _thisObject, Reference podNameList) {
                Reference reference;
                CallSite[] callSiteArray = _deletePods_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.podNameList = reference = podNameList;
            }

            public Object doCall(Object item) {
                CallSite[] callSiteArray = _deletePods_closure1.$getCallSiteArray();
                return callSiteArray[0].call(this.podNameList.get(), callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(item)), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(item)));
            }

            public Map getPodNameList() {
                CallSite[] callSiteArray = _deletePods_closure1.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.podNameList.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deletePods_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "put";
                stringArray[1] = "name";
                stringArray[2] = "metadata";
                stringArray[3] = "uid";
                stringArray[4] = "metadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _deletePods_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deletePods_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deletePods_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[199].call(callSiteArray[200].callGetProperty(callSiteArray[201].call(callSiteArray[202].callGetProperty((Object)((KubernetesV1Credentials)credentials2.get())), (Object)((String)namespace2.get()), callSiteArray[203].callGetProperty(callSiteArray[204].callGetProperty(controllerSet2.get())))), (Object)new _deletePods_closure1(this, this, podNameList));
        Reference getPodState = new Reference(null);
        public class _deletePods_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference getPodState;
            private /* synthetic */ Reference controllerSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deletePods_closure2(Object _outerInstance, Object _thisObject, Reference credentials, Reference namespace, Reference getPodState, Reference controllerSet) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.credentials = reference4 = credentials;
                this.namespace = reference3 = namespace;
                this.getPodState = reference2 = getPodState;
                this.controllerSet = reference = controllerSet;
            }

            /*
             * WARNING - void declaration
             */
            public Object doCall(Object k, Object v) {
                void var2_2;
                Reference k2 = new Reference(k);
                Reference v2 = new Reference((Object)var2_2);
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGetProperty(this.credentials.get()), ArrayUtil.createArray((Object)k2.get(), (Object)this.namespace.get(), null, null, null, (Object)false));
                public class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference credentials;
                    private /* synthetic */ Reference k;
                    private /* synthetic */ Reference namespace;
                    private /* synthetic */ Reference v;
                    private /* synthetic */ Reference controllerSet;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference credentials, Reference k, Reference namespace, Reference v, Reference controllerSet) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.credentials = reference5 = credentials;
                        this.k = reference4 = k;
                        this.namespace = reference3 = namespace;
                        this.v = reference2 = v;
                        this.controllerSet = reference = controllerSet;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        V1Pod pod = (V1Pod)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(this.credentials.get()), this.k.get(), this.namespace.get()), V1Pod.class);
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (DefaultTypeTransformation.booleanUnbox((Object)pod) ? ScriptBytecodeAdapter.compareNotEqual((Object)this.v.get(), (Object)callSiteArray[2].callGetPropertySafe(callSiteArray[3].callGetProperty((Object)pod))) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callGetPropertySafe(callSiteArray[5].callGetProperty((Object)pod)), (Object)"Running") : ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callGetProperty(this.controllerSet.get()), (Object)callSiteArray[7].callGetProperty(KubernetesUtil.class))) : (DefaultTypeTransformation.booleanUnbox((Object)pod) ? ScriptBytecodeAdapter.compareNotEqual((Object)this.v.get(), (Object)callSiteArray[8].callGetPropertySafe(callSiteArray[9].callGetProperty((Object)pod))) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[10].callGetPropertySafe(callSiteArray[11].callGetProperty((Object)pod)), (Object)"Running") : ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[12].callGetProperty(this.controllerSet.get()), (Object)callSiteArray[13].callGetProperty(KubernetesUtil.class)))) {
                            return true;
                        }
                        return false;
                    }

                    public KubernetesV1Credentials getCredentials() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (KubernetesV1Credentials)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), KubernetesV1Credentials.class);
                    }

                    public Object getK() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.k.get();
                    }

                    public String getNamespace() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.namespace.get());
                    }

                    public Object getV() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.v.get();
                    }

                    public Object getControllerSet() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.controllerSet.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getPodStatus";
                        stringArray[1] = "clientApiAdaptor";
                        stringArray[2] = "uid";
                        stringArray[3] = "metadata";
                        stringArray[4] = "phase";
                        stringArray[5] = "status";
                        stringArray[6] = "kind";
                        stringArray[7] = "CONTROLLERS_DAEMONSET_KIND";
                        stringArray[8] = "uid";
                        stringArray[9] = "metadata";
                        stringArray[10] = "phase";
                        stringArray[11] = "status";
                        stringArray[12] = "kind";
                        stringArray[13] = "CONTROLLERS_DAEMONSET_KIND";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[14];
                        _closure3.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure3.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure3.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                _closure3 _closure35 = new _closure3((Object)this, this.getThisObject(), this.credentials, k2, this.namespace, v2, this.controllerSet);
                this.getPodState.set((Object)_closure35);
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(this.credentials.get()), this.getPodState.get()))) {
                    throw (Throwable)callSiteArray[4].callConstructor(KubernetesClientOperationException.class, (Object)new GStringImpl(new Object[]{k2.get(), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(this.controllerSet.get())), this.namespace.get()}, new String[]{"Failed to launch a new pod(", ") for ServerGroup ", " in ", "."}));
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public Object call(Object k, Object v) {
                void var2_2;
                Reference k2 = new Reference(k);
                Reference v2 = new Reference((Object)var2_2);
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, k2.get(), v2.get());
            }

            public KubernetesV1Credentials getCredentials() {
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return (KubernetesV1Credentials)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), KubernetesV1Credentials.class);
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object getGetPodState() {
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return this.getPodState.get();
            }

            public Object getControllerSet() {
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return this.controllerSet.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deletePods_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "deletePod";
                stringArray[1] = "clientApiAdaptor";
                stringArray[2] = "blockUntilResourceConsistent";
                stringArray[3] = "clientApiAdaptor";
                stringArray[4] = "<$constructor$>";
                stringArray[5] = "name";
                stringArray[6] = "metadata";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _deletePods_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deletePods_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deletePods_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[205].call(callSiteArray[206].call((Object)((Map)podNameList.get()), callSiteArray[207].call(callSiteArray[208].call(Map.Entry.class))), (Object)new _deletePods_closure2(this, this, credentials2, namespace2, getPodState, controllerSet2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeployKubernetesAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public final DeployKubernetesAtomicOperationDescription getDescription() {
        return this.description;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "deployDescription";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "asList";
        stringArray[5] = "toString";
        stringArray[6] = "namespace";
        stringArray[7] = "metadata";
        stringArray[8] = "name";
        stringArray[9] = "metadata";
        stringArray[10] = "name";
        stringArray[11] = "metadata";
        stringArray[12] = "putAt";
        stringArray[13] = "serverGroupNameByRegion";
        stringArray[14] = "namespace";
        stringArray[15] = "metadata";
        stringArray[16] = "updateStatus";
        stringArray[17] = "task";
        stringArray[18] = "updateStatus";
        stringArray[19] = "task";
        stringArray[20] = "credentials";
        stringArray[21] = "credentials";
        stringArray[22] = "namespace";
        stringArray[23] = "source";
        stringArray[24] = "namespace";
        stringArray[25] = "source";
        stringArray[26] = "namespace";
        stringArray[27] = "namespace";
        stringArray[28] = "validateNamespace";
        stringArray[29] = "getAt";
        stringArray[30] = "imagePullSecrets";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "combineAppStackDetail";
        stringArray[33] = "application";
        stringArray[34] = "stack";
        stringArray[35] = "freeFormDetails";
        stringArray[36] = "kind";
        stringArray[37] = "deployController";
        stringArray[38] = "updateStatus";
        stringArray[39] = "task";
        stringArray[40] = "sequence";
        stringArray[41] = "generateServerGroupName";
        stringArray[42] = "application";
        stringArray[43] = "stack";
        stringArray[44] = "freeFormDetails";
        stringArray[45] = "sequence";
        stringArray[46] = "resolveNextServerGroupName";
        stringArray[47] = "application";
        stringArray[48] = "stack";
        stringArray[49] = "freeFormDetails";
        stringArray[50] = "updateStatus";
        stringArray[51] = "task";
        stringArray[52] = "hasDeployment";
        stringArray[53] = "useSourceCapacity";
        stringArray[54] = "source";
        stringArray[55] = "updateStatus";
        stringArray[56] = "task";
        stringArray[57] = "serverGroupName";
        stringArray[58] = "source";
        stringArray[59] = "getReplicationController";
        stringArray[60] = "apiAdaptor";
        stringArray[61] = "serverGroupName";
        stringArray[62] = "source";
        stringArray[63] = "getReplicaSet";
        stringArray[64] = "apiAdaptor";
        stringArray[65] = "serverGroupName";
        stringArray[66] = "source";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "serverGroupName";
        stringArray[69] = "source";
        stringArray[70] = "updateStatus";
        stringArray[71] = "task";
        stringArray[72] = "replicas";
        stringArray[73] = "spec";
        stringArray[74] = "updateStatus";
        stringArray[75] = "task";
        stringArray[76] = "toReplicaSet";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "spec";
        stringArray[79] = "updateStatus";
        stringArray[80] = "task";
        stringArray[81] = "toReplicaSet";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "spec";
        stringArray[84] = "createReplicaSet";
        stringArray[85] = "apiAdaptor";
        stringArray[86] = "updateStatus";
        stringArray[87] = "task";
        stringArray[88] = "name";
        stringArray[89] = "metadata";
        stringArray[90] = "getDeployment";
        stringArray[91] = "apiAdaptor";
        stringArray[92] = "updateStatus";
        stringArray[93] = "task";
        stringArray[94] = "createDeployment";
        stringArray[95] = "apiAdaptor";
        stringArray[96] = "build";
        stringArray[97] = "toDeployment";
        stringArray[98] = "<$constructor$>";
        stringArray[99] = "updateStatus";
        stringArray[100] = "task";
        stringArray[101] = "done";
        stringArray[102] = "toDeployment";
        stringArray[103] = "editDeployment";
        stringArray[104] = "apiAdaptor";
        stringArray[105] = "updateStatus";
        stringArray[106] = "task";
        stringArray[107] = "scalingPolicy";
        stringArray[108] = "updateStatus";
        stringArray[109] = "task";
        stringArray[110] = "DEPLOYMENT_KIND";
        stringArray[111] = "SERVER_GROUP_KIND";
        stringArray[112] = "getApiVersion";
        stringArray[113] = "getDeployment";
        stringArray[114] = "apiAdaptor";
        stringArray[115] = "getApiVersion";
        stringArray[116] = "build";
        stringArray[117] = "toAutoscaler";
        stringArray[118] = "<$constructor$>";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "getAutoscaler";
        stringArray[121] = "apiAdaptor";
        stringArray[122] = "deleteAutoscaler";
        stringArray[123] = "apiAdaptor";
        stringArray[124] = "createAutoscaler";
        stringArray[125] = "apiAdaptor";
        stringArray[126] = "isUpdateControllerEnabled";
        stringArray[127] = "validateSequence";
        stringArray[128] = "generateServerGroupName";
        stringArray[129] = "application";
        stringArray[130] = "stack";
        stringArray[131] = "freeFormDetails";
        stringArray[132] = "intValue";
        stringArray[133] = "sequence";
        stringArray[134] = "kind";
        stringArray[135] = "CONTROLLERS_STATEFULSET_KIND";
        stringArray[136] = "deployStatefulSet";
        stringArray[137] = "CONTROLLERS_DAEMONSET_KIND";
        stringArray[138] = "deployDaemonSet";
        stringArray[139] = "<$constructor$>";
        stringArray[140] = "kind";
        stringArray[141] = "toKubernetesController";
        stringArray[142] = "updateStatus";
        stringArray[143] = "task";
        stringArray[144] = "toStatefulSet";
        stringArray[145] = "getStatefulSet";
        stringArray[146] = "clientApiAdaptor";
        stringArray[147] = "updateStatus";
        stringArray[148] = "task";
        stringArray[149] = "replaceStatfulSet";
        stringArray[150] = "clientApiAdaptor";
        stringArray[151] = "name";
        stringArray[152] = "type";
        stringArray[153] = "updateStrategy";
        stringArray[154] = "updateController";
        stringArray[155] = "deletePods";
        stringArray[156] = "updateStatus";
        stringArray[157] = "task";
        stringArray[158] = "createStatfulSet";
        stringArray[159] = "clientApiAdaptor";
        stringArray[160] = "updateStatus";
        stringArray[161] = "task";
        stringArray[162] = "createStatfulSet";
        stringArray[163] = "clientApiAdaptor";
        stringArray[164] = "scalingPolicy";
        stringArray[165] = "updateStatus";
        stringArray[166] = "task";
        stringArray[167] = "toAutoscaler";
        stringArray[168] = "<$constructor$>";
        stringArray[169] = "kind";
        stringArray[170] = "getAutoscaler";
        stringArray[171] = "clientApiAdaptor";
        stringArray[172] = "deleteAutoscaler";
        stringArray[173] = "clientApiAdaptor";
        stringArray[174] = "createAutoscaler";
        stringArray[175] = "clientApiAdaptor";
        stringArray[176] = "updateStatus";
        stringArray[177] = "task";
        stringArray[178] = "toDaemonSet";
        stringArray[179] = "getDaemonSet";
        stringArray[180] = "clientApiAdaptor";
        stringArray[181] = "updateStatus";
        stringArray[182] = "task";
        stringArray[183] = "replaceDaemonSet";
        stringArray[184] = "clientApiAdaptor";
        stringArray[185] = "name";
        stringArray[186] = "type";
        stringArray[187] = "updateStrategy";
        stringArray[188] = "updateController";
        stringArray[189] = "deletePods";
        stringArray[190] = "updateStatus";
        stringArray[191] = "task";
        stringArray[192] = "createDaemonSet";
        stringArray[193] = "clientApiAdaptor";
        stringArray[194] = "updateStatus";
        stringArray[195] = "task";
        stringArray[196] = "createDaemonSet";
        stringArray[197] = "clientApiAdaptor";
        stringArray[198] = "<$constructor$>";
        stringArray[199] = "forEach";
        stringArray[200] = "items";
        stringArray[201] = "getPods";
        stringArray[202] = "clientApiAdaptor";
        stringArray[203] = "labels";
        stringArray[204] = "metadata";
        stringArray[205] = "forEach";
        stringArray[206] = "toSorted";
        stringArray[207] = "reversed";
        stringArray[208] = "comparingByKey";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[209];
        DeployKubernetesAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DeployKubernetesAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DeployKubernetesAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

