/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactTypes;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactReplacer {
    private static final Logger log = LoggerFactory.getLogger(ArtifactReplacer.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    List<Replacer> replacers = new ArrayList<Replacer>();

    public ArtifactReplacer addReplacer(Replacer replacer) {
        this.replacers.add(replacer);
        return this;
    }

    private static List<Artifact> filterKubernetesArtifactsByNamespaceAndAccount(String namespace, String account, List<Artifact> artifacts) {
        return artifacts.stream().filter(a -> {
            String type = a.getType();
            if (StringUtils.isEmpty((String)type)) {
                log.warn("Artifact {} without a type, ignoring", a);
                return false;
            }
            if (!type.startsWith("kubernetes/")) {
                return true;
            }
            String location = a.getLocation();
            boolean locationMatches = StringUtils.isEmpty((String)location) ? StringUtils.isEmpty((String)namespace) : location.equals(namespace);
            String artifactAccount = KubernetesArtifactConverter.getAccount(a);
            boolean accountMatches = StringUtils.isEmpty((String)artifactAccount) || artifactAccount.equals(account);
            return accountMatches && locationMatches;
        }).collect(Collectors.toList());
    }

    public ReplaceResult replaceAll(KubernetesManifest input, List<Artifact> artifacts, String namespace, String account) {
        DocumentContext document;
        log.debug("Doing replacement on {} using {}", (Object)input, artifacts);
        List<Artifact> finalArtifacts = ArtifactReplacer.filterKubernetesArtifactsByNamespaceAndAccount(namespace, account, artifacts);
        try {
            document = JsonPath.using((Configuration)configuration).parse(mapper.writeValueAsString((Object)input));
        }
        catch (JsonProcessingException e) {
            log.error("Malformed manifest", (Throwable)e);
            throw new RuntimeException(e);
        }
        Set<Artifact> replacedArtifacts = this.replacers.stream().map(r -> finalArtifacts.stream().filter(a -> r.replaceIfPossible(document, (Artifact)a)).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        try {
            return ReplaceResult.builder().manifest((KubernetesManifest)mapper.readValue(document.jsonString(), KubernetesManifest.class)).boundArtifacts(replacedArtifacts).build();
        }
        catch (IOException e) {
            log.error("Malformed Document Context", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Set<Artifact> findAll(KubernetesManifest input) {
        DocumentContext document;
        try {
            document = JsonPath.using((Configuration)configuration).parse(mapper.writeValueAsString((Object)input));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Malformed manifest", e);
        }
        return this.replacers.stream().map(r -> {
            try {
                return ((List)mapper.convertValue((Object)r.findAll(document), (TypeReference)new TypeReference<List<String>>(){})).stream().map(s -> {
                    String name;
                    String nameFromReference = r.getNameFromReference((String)s);
                    String string = name = nameFromReference == null ? s : nameFromReference;
                    if (((Replacer)r).namePattern == null || nameFromReference != null) {
                        return Artifact.builder().type(r.getType().toString()).reference(s).name(name).build();
                    }
                    return null;
                }).filter(Objects::nonNull);
            }
            catch (Exception e) {
                log.debug("Failure converting artifacts for {} using {} (skipping)", new Object[]{input.getFullResourceName(), r, e});
                return Stream.empty();
            }
        }).flatMap(x -> x).collect(Collectors.toSet());
    }

    public static class ReplaceResult {
        private KubernetesManifest manifest;
        private Set<Artifact> boundArtifacts = new HashSet<Artifact>();

        public static ReplaceResultBuilder builder() {
            return new ReplaceResultBuilder();
        }

        public KubernetesManifest getManifest() {
            return this.manifest;
        }

        public Set<Artifact> getBoundArtifacts() {
            return this.boundArtifacts;
        }

        public ReplaceResult setManifest(KubernetesManifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public ReplaceResult setBoundArtifacts(Set<Artifact> boundArtifacts) {
            this.boundArtifacts = boundArtifacts;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceResult)) {
                return false;
            }
            ReplaceResult other = (ReplaceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            KubernetesManifest this$manifest = this.getManifest();
            KubernetesManifest other$manifest = other.getManifest();
            if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
                return false;
            }
            Set<Artifact> this$boundArtifacts = this.getBoundArtifacts();
            Set<Artifact> other$boundArtifacts = other.getBoundArtifacts();
            return !(this$boundArtifacts == null ? other$boundArtifacts != null : !((Object)this$boundArtifacts).equals(other$boundArtifacts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReplaceResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            KubernetesManifest $manifest = this.getManifest();
            result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
            Set<Artifact> $boundArtifacts = this.getBoundArtifacts();
            result = result * 59 + ($boundArtifacts == null ? 43 : ((Object)$boundArtifacts).hashCode());
            return result;
        }

        public String toString() {
            return "ArtifactReplacer.ReplaceResult(manifest=" + this.getManifest() + ", boundArtifacts=" + this.getBoundArtifacts() + ")";
        }

        public ReplaceResult() {
        }

        public ReplaceResult(KubernetesManifest manifest, Set<Artifact> boundArtifacts) {
            this.manifest = manifest;
            this.boundArtifacts = boundArtifacts;
        }

        public static class ReplaceResultBuilder {
            private KubernetesManifest manifest;
            private Set<Artifact> boundArtifacts;

            ReplaceResultBuilder() {
            }

            public ReplaceResultBuilder manifest(KubernetesManifest manifest) {
                this.manifest = manifest;
                return this;
            }

            public ReplaceResultBuilder boundArtifacts(Set<Artifact> boundArtifacts) {
                this.boundArtifacts = boundArtifacts;
                return this;
            }

            public ReplaceResult build() {
                return new ReplaceResult(this.manifest, this.boundArtifacts);
            }

            public String toString() {
                return "ArtifactReplacer.ReplaceResult.ReplaceResultBuilder(manifest=" + this.manifest + ", boundArtifacts=" + this.boundArtifacts + ")";
            }
        }
    }

    public static class Replacer {
        private static final Logger log = LoggerFactory.getLogger(Replacer.class);
        private final String replacePath;
        private final String findPath;
        private final Pattern namePattern;
        private final Function<String, String> nameFromReference;
        private final ArtifactTypes type;

        private static String substituteField(String result, String fieldName, String field) {
            field = field == null ? "" : field;
            return result.replace("{%" + fieldName + "%}", field);
        }

        private static String processPath(String path, Artifact artifact) {
            String result = Replacer.substituteField(path, "name", artifact.getName());
            result = Replacer.substituteField(result, "type", artifact.getType());
            result = Replacer.substituteField(result, "version", artifact.getVersion());
            result = Replacer.substituteField(result, "reference", artifact.getReference());
            return result;
        }

        ArrayNode findAll(DocumentContext obj) {
            return (ArrayNode)obj.read(this.findPath, new Predicate[0]);
        }

        String getNameFromReference(String reference) {
            if (this.nameFromReference != null) {
                return this.nameFromReference.apply(reference);
            }
            if (this.namePattern != null) {
                Matcher m = this.namePattern.matcher(reference);
                if (m.find() && m.groupCount() > 0 && StringUtils.isNotEmpty((String)m.group(1))) {
                    return m.group(1);
                }
                return null;
            }
            return null;
        }

        boolean replaceIfPossible(DocumentContext obj, Artifact artifact) {
            Object get;
            if (artifact == null || StringUtils.isEmpty((String)artifact.getType())) {
                throw new IllegalArgumentException("Artifact and artifact type must be set.");
            }
            if (!artifact.getType().equals(this.type.toString())) {
                return false;
            }
            String jsonPath = Replacer.processPath(this.replacePath, artifact);
            log.debug("Processed jsonPath == {}", (Object)jsonPath);
            try {
                get = obj.read(jsonPath, new Predicate[0]);
            }
            catch (PathNotFoundException e) {
                return false;
            }
            if (get == null || get instanceof ArrayNode && ((ArrayNode)get).size() == 0) {
                return false;
            }
            log.info("Found valid swap for " + artifact + " using " + jsonPath + ": " + get);
            obj.set(jsonPath, (Object)artifact.getReference(), new Predicate[0]);
            return true;
        }

        public static ReplacerBuilder builder() {
            return new ReplacerBuilder();
        }

        public Replacer(String replacePath, String findPath, Pattern namePattern, Function<String, String> nameFromReference, ArtifactTypes type) {
            this.replacePath = replacePath;
            this.findPath = findPath;
            this.namePattern = namePattern;
            this.nameFromReference = nameFromReference;
            this.type = type;
        }

        public ArtifactTypes getType() {
            return this.type;
        }

        public static class ReplacerBuilder {
            private String replacePath;
            private String findPath;
            private Pattern namePattern;
            private Function<String, String> nameFromReference;
            private ArtifactTypes type;

            ReplacerBuilder() {
            }

            public ReplacerBuilder replacePath(String replacePath) {
                this.replacePath = replacePath;
                return this;
            }

            public ReplacerBuilder findPath(String findPath) {
                this.findPath = findPath;
                return this;
            }

            public ReplacerBuilder namePattern(Pattern namePattern) {
                this.namePattern = namePattern;
                return this;
            }

            public ReplacerBuilder nameFromReference(Function<String, String> nameFromReference) {
                this.nameFromReference = nameFromReference;
                return this;
            }

            public ReplacerBuilder type(ArtifactTypes type) {
                this.type = type;
                return this;
            }

            public Replacer build() {
                return new Replacer(this.replacePath, this.findPath, this.namePattern, this.nameFromReference, this.type);
            }

            public String toString() {
                return "ArtifactReplacer.Replacer.ReplacerBuilder(replacePath=" + this.replacePath + ", findPath=" + this.findPath + ", namePattern=" + this.namePattern + ", nameFromReference=" + this.nameFromReference + ", type=" + this.type + ")";
            }
        }
    }
}

