/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact;

import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.ArtifactProvider;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.Map;

public abstract class KubernetesArtifactConverter {
    public abstract Artifact toArtifact(ArtifactProvider var1, KubernetesManifest var2, String var3);

    public abstract KubernetesCoordinates toCoordinates(Artifact var1);

    public abstract String getDeployedName(Artifact var1);

    protected String getType(KubernetesManifest manifest) {
        return String.join((CharSequence)"/", KubernetesCloudProvider.getID(), manifest.getKind().toString());
    }

    protected KubernetesKind getKind(Artifact artifact) {
        String[] split = artifact.getType().split("/", -1);
        if (split.length != 2) {
            throw new IllegalArgumentException("Not a kubernetes artifact: " + artifact);
        }
        if (!split[0].equals(KubernetesCloudProvider.getID())) {
            throw new IllegalArgumentException("Not a kubernetes artifact: " + artifact);
        }
        return KubernetesKind.fromString(split[1]);
    }

    protected String getNamespace(Artifact artifact) {
        return artifact.getLocation();
    }

    public static String getAccount(Artifact artifact) {
        String account = "";
        Map metadata = artifact.getMetadata();
        if (metadata != null) {
            account = metadata.getOrDefault("account", "");
        }
        return account;
    }
}

