/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.ArtifactProvider;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesVersionedArtifactConverter
extends KubernetesArtifactConverter {
    private static final Logger log = LoggerFactory.getLogger(KubernetesVersionedArtifactConverter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Artifact toArtifact(ArtifactProvider provider, KubernetesManifest manifest, String account) {
        String type = this.getType(manifest);
        String name = manifest.getName();
        String location = manifest.getNamespace();
        String version = this.getVersion(provider, type, name, location, manifest);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("account", account);
        return Artifact.builder().type(type).name(name).location(location).version(version).reference(this.getDeployedName(name, version)).metadata(metadata).build();
    }

    @Override
    public KubernetesCoordinates toCoordinates(Artifact artifact) {
        return KubernetesCoordinates.builder().kind(this.getKind(artifact)).name(this.getDeployedName(artifact)).namespace(this.getNamespace(artifact)).build();
    }

    @Override
    public String getDeployedName(Artifact artifact) {
        return this.getDeployedName(artifact.getName(), artifact.getVersion());
    }

    private String getDeployedName(String name, String version) {
        return String.join((CharSequence)"-", name, version);
    }

    private String getVersion(ArtifactProvider provider, String type, String name, String location, KubernetesManifest manifest) {
        List priorVersions = provider.getArtifacts(type, name, location);
        Optional<String> maybeVersion = this.findMatchingVersion(priorVersions, manifest);
        if (maybeVersion.isPresent()) {
            String version = maybeVersion.get();
            log.info("Manifest {} was already deployed at version {} - reusing.", (Object)manifest, (Object)version);
            return version;
        }
        return this.findGreatestUnusedVersion(priorVersions);
    }

    private String findGreatestUnusedVersion(List<Artifact> priorVersions) {
        List taken = priorVersions.stream().map(Artifact::getVersion).filter(Objects::nonNull).filter(v -> v.startsWith("v")).map(v -> v.substring(1)).map(v -> {
            try {
                return Integer.valueOf(v);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(i -> i >= 0).collect(Collectors.toList());
        taken.sort(Integer::compareTo);
        int sequence = 0;
        if (!taken.isEmpty()) {
            sequence = (Integer)taken.get(taken.size() - 1) + 1;
        }
        if (sequence < 1000) {
            return String.format("v%03d", sequence);
        }
        return String.format("v%d", sequence);
    }

    private Optional<String> findMatchingVersion(List<Artifact> priorVersions, KubernetesManifest manifest) {
        return priorVersions.stream().filter(a -> this.getLastAppliedConfiguration((Artifact)a).map(c -> c.nonMetadataEquals(manifest)).orElse(false)).findFirst().map(Artifact::getVersion);
    }

    private Optional<KubernetesManifest> getLastAppliedConfiguration(Artifact artifact) {
        if (artifact.getMetadata() == null) {
            return Optional.empty();
        }
        Object rawLastAppliedConfiguration = artifact.getMetadata().get("lastAppliedConfiguration");
        if (rawLastAppliedConfiguration == null) {
            return Optional.empty();
        }
        try {
            KubernetesManifest manifest = (KubernetesManifest)objectMapper.convertValue(rawLastAppliedConfiguration, KubernetesManifest.class);
            return Optional.of(manifest);
        }
        catch (Exception e) {
            log.warn("Malformed lastAppliedConfiguration entry in {}: ", (Object)artifact, (Object)e);
            return Optional.empty();
        }
    }
}

