/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.AgentIntervalAware;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesMetricCachingAgent
extends KubernetesCachingAgent<KubernetesV2Credentials>
implements AgentIntervalAware {
    private static final Logger log = LoggerFactory.getLogger(KubernetesMetricCachingAgent.class);
    protected String providerName = KubernetesCloudProvider.getID();
    private final Long agentInterval;
    protected Collection<AgentDataType> providedDataTypes = Collections.unmodifiableCollection(Collections.singletonList(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Kind.KUBERNETES_METRIC.toString())));

    protected KubernetesMetricCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval) {
        super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount);
        this.agentInterval = agentInterval;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        log.info(this.getAgentType() + " is starting");
        this.reloadNamespaces();
        List<CacheData> cacheData = this.namespaces.parallelStream().map(n -> {
            try {
                return ((KubernetesV2Credentials)this.credentials).topPod((String)n).stream().map(m -> KubernetesCacheDataConverter.convertPodMetric(this.accountName, n, m));
            }
            catch (KubectlJobExecutor.KubectlException e) {
                if (e.getMessage().contains("not available")) {
                    log.warn("Metrics for namespace '" + n + "' in account '" + this.accountName + "' have not been recorded yet.");
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).flatMap(x -> x).collect(Collectors.toList());
        List invertedRelationships = cacheData.stream().map(KubernetesCacheDataConverter::invertRelationships).flatMap(Collection::stream).collect(Collectors.toList());
        cacheData.addAll(invertedRelationships);
        Map<String, Collection<CacheData>> entries = KubernetesCacheDataConverter.stratifyCacheDataByGroup(KubernetesCacheDataConverter.dedupCacheData(cacheData));
        KubernetesCacheDataConverter.logStratifiedCacheData(this.getAgentType(), entries);
        return new DefaultCacheResult(entries);
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Long getAgentInterval() {
        return this.agentInterval;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.providedDataTypes;
    }
}

