/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2OnDemandCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesUnregisteredCustomResourceCachingAgent
extends KubernetesV2OnDemandCachingAgent {
    private static final Logger log = LoggerFactory.getLogger(KubernetesUnregisteredCustomResourceCachingAgent.class);

    KubernetesUnregisteredCustomResourceCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, KubernetesResourcePropertyRegistry propertyRegistry, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval) {
        super(namedAccountCredentials, propertyRegistry, objectMapper, registry, agentIndex, agentCount, agentInterval);
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableSet(this.primaryKinds().stream().filter(((KubernetesV2Credentials)this.credentials)::isValidKind).map(k -> AgentDataType.Authority.AUTHORITATIVE.forType(k.toString())).collect(Collectors.toSet()));
    }

    @Override
    protected List<KubernetesKind> primaryKinds() {
        return ((KubernetesV2Credentials)this.credentials).getCrds();
    }
}

