/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesV2AbstractManifestProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.ManifestProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2LiveManifestProvider
extends KubernetesV2AbstractManifestProvider {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2LiveManifestProvider.class);
    private final AccountCredentialsRepository credentialsRepository;
    private final KubernetesResourcePropertyRegistry registry;

    @Autowired
    public KubernetesV2LiveManifestProvider(AccountCredentialsRepository credentialsRepository, KubernetesResourcePropertyRegistry registry) {
        this.credentialsRepository = credentialsRepository;
        this.registry = registry;
    }

    public KubernetesV2Manifest getManifest(String account, String location, String name) {
        Pair<KubernetesKind, String> parsedName;
        if (!this.isAccountRelevant(account)) {
            return null;
        }
        if (!this.makesLiveCalls(account)) {
            return null;
        }
        try {
            parsedName = KubernetesManifest.fromFullResourceName(name);
        }
        catch (Exception e) {
            return null;
        }
        log.info("Live call to lookup manifest '{}:{}' in namespace '{}' under account '{}'", new Object[]{parsedName.getRight(), parsedName.getLeft(), location, account});
        KubernetesV2Credentials credentials = this.getCredentials(account).orElseThrow(() -> new IllegalStateException("Already verified that credentials are relevant"));
        KubernetesManifest manifest = credentials.get((KubernetesKind)parsedName.getLeft(), location, (String)parsedName.getRight());
        if (manifest == null) {
            return null;
        }
        String namespace = manifest.getNamespace();
        KubernetesKind kind = manifest.getKind();
        List<KubernetesManifest> events = credentials.eventsFor(kind, namespace, (String)parsedName.getRight());
        List<Map> metrics = Collections.emptyList();
        return this.buildManifest(account, manifest, events, metrics);
    }

    public List<KubernetesV2Manifest> getClusterAndSortAscending(String account, String location, String kind, String app, String cluster, ManifestProvider.Sort sort) {
        return Collections.emptyList();
    }

    @Override
    public AccountCredentialsRepository getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Override
    public KubernetesResourcePropertyRegistry getRegistry() {
        return this.registry;
    }
}

